% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_omdb_gif.R
\name{search_omdb_gif}
\alias{search_omdb_gif}
\title{Search OMDB Gif}
\usage{
search_omdb_gif(movie, type = "movie", year = NULL, page = 1,
  API_KEY = Sys.getenv("API_KEY"))
}
\arguments{
\item{movie}{String of movie/series name}

\item{type}{Default: 'movie'. Valid options are 'movie' or 'series'.}

\item{year}{Optional. Year of release.}

\item{page}{The number of results returned. 1: 10 results, 2: 20 results...}

\item{API_KEY}{OMBD Api Key. Default: Get the Api Key from system environment. Use Sys.setenv('API_KEY' = 'XXXXX'). More information in: http://www.omdbapi.com/apikey.aspx}
}
\value{
Returns a gif of the movies searched (an image if only one result is returned)
}
\description{
This function searches OMDB Api Items (movies or series) by name, type and year.
}
\examples{
\dontrun{
search_omdb_gif('Titanic')
}
}
\author{
Alberto Almuiña
}
