% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpdtest.R
\name{pVals}
\alias{pVals}
\title{Randomized phi-divergence test: simulated p-value part}
\usage{
pVals(x, p, lambda = 1, B = 200, z = 40, rs = 1250, n.cores, nDim, r)
}
\arguments{
\item{x}{the obtained multinomial distribution data.Same data structure
as the data parameter in \link{rpdTest}.}

\item{p}{the probability vector in the null hypothesis. It is necessary to
ensure beforehand that the vectors are valid.}

\item{lambda}{a control parameter of the statistic calculation,
adjusting it will significantly change the final obtained statistic.}

\item{B}{an integer specifying the number of simulation data on the expected
null distribution (p) of the Monte Carlo simulation.}

\item{z}{an integer specifying the number by which to divide
the observation data group in a Monte Carlo simulation.}

\item{rs}{an integer that adjusts the number of statistics calculated in simulation.}

\item{n.cores}{an integer used to specify the number of cores used
to perform parallel operations. The default is to use the maximum number
of cores available to the computer minus one.}

\item{nDim}{an integer indicating the dimension of the uniformly
distributed vectors generated during the computation of the statistic.
It is equal to the number of experiments for the multinomial distribution.}

\item{r}{an integer indicating the dimension of the data parameter.
It is equal to the number of possible outcomes of the multinomial distribution.}
}
\value{
an numeric value indicating simulated p-value.
}
\description{
This is one of the auxiliary functions used to execute the rpdTest function.
This function can be used to calculate p-values based on Monte Carlo simulation.
Users generally do not need to call this function except for testing purposes.
For more detailed description one can find in\link{rpdTest}.
}
\examples{
d <- c(20,40)
#The next line is equivalent to rpdTest(d,sim.pValue = TRUE,n.cores = 2)$p.value
#It usually takes 1-2 minutes to perform this calculation process
\donttest{
pVals(d, c(1/2,1/2), B = 200, z = 40, rs = 1250, n.cores = 2, nDim = sum(d), r = length(d))
}
}
