% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RVCompare.R
\name{getEmpiricalCumulativeDistributions}
\alias{getEmpiricalCumulativeDistributions}
\title{Get the empirical distribution from samples.}
\usage{
getEmpiricalCumulativeDistributions(
  X_A_observed,
  X_B_observed,
  nOfEstimationPoints,
  EPSILON,
  trapezoid = TRUE
)
}
\arguments{
\item{X_A_observed}{array of the observed samples (real values) of X_A.}

\item{X_B_observed}{array of the observed samples (real values) of X_B.}

\item{nOfEstimationPoints}{the number of points in the interval [0,1] in which the cumulative density is estimated + 2.}

\item{EPSILON}{(optional, default value 1e-20) minimum difference between two values to be considered different.}

\item{trapezoid}{(optional, default TRUE) if trapezoid=FALSE the non smooth empirical distribution is given. This is
what the WDK uses the empirical as the estimation.}
}
\value{
a list with two fields: the empirical distributions of X'A and X'B.
}
\description{
Given the observed sampels of X_A (or X_B) returns the empirical cumulative distribution
function of Y_A (or Y_B)
}
\examples{
### Example 1 ###
c <- getEmpiricalCumulativeDistributions(c(1:5),c(1:3,2:3), 170, EPSILON=1e-20, trapezoid=FALSE)
plot(c$p, c$Y_A_cumulative_estimation, type="l")
lines(x=c$p, y=c$Y_B_cumulative_estimation, col="red")
}
