% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack_rwnn.R
\name{stack_rwnn}
\alias{stack_rwnn}
\alias{stack_rwnn.formula}
\title{Stacking random weight neural networks}
\usage{
stack_rwnn(
  formula,
  data = NULL,
  n_hidden = c(),
  lambda = NULL,
  B = 100,
  optimise = FALSE,
  folds = 10,
  method = NULL,
  type = NULL,
  control = list()
)

\method{stack_rwnn}{formula}(
  formula,
  data = NULL,
  n_hidden = c(),
  lambda = NULL,
  B = 100,
  optimise = FALSE,
  folds = 10,
  method = NULL,
  type = NULL,
  control = list()
)
}
\arguments{
\item{formula}{A \link{formula} specifying features and targets used to estimate the parameters of the output layer.}

\item{data}{A data-set (either a \link{data.frame} or a \link[tibble]{tibble}) used to estimate the parameters of the output layer.}

\item{n_hidden}{A vector of integers designating the number of neurons in each of the hidden layers (the length of the list is taken as the number of hidden layers).}

\item{lambda}{The penalisation constant(s) passed to either \link{rwnn} or \link{ae_rwnn} (see \code{method} argument).}

\item{B}{The number of models in the stack.}

\item{optimise}{TRUE/FALSE: Should the stacking weights be optimised (or should the stack just predict the average)?}

\item{folds}{The number of folds used when optimising the stacking weights (see \code{optimise} argument).}

\item{method}{The penalisation type passed to \link{ae_rwnn}. Set to \code{NULL} (default), \code{"l1"}, or \code{"l2"}. If \code{NULL}, \link{rwnn} is used as the base learner.}

\item{type}{A string indicating whether this is a regression or classification problem.}

\item{control}{A list of additional arguments passed to the \link{control_rwnn} function.}
}
\value{
An \link{ERWNN-object}.
}
\description{
Use stacking to create ensemble random weight neural networks.
}
\examples{
n_hidden <- c(20, 15, 10, 5)
lambda <- 0.01
B <- 100

## Using the average of the stack to predict new targets
\donttest{
m <- stack_rwnn(y ~ ., data = example_data, n_hidden = n_hidden,
                lambda = lambda, B = B)
}

## Using the optimised weighting of the stack to predict new targets
\donttest{
m <- stack_rwnn(y ~ ., data = example_data, n_hidden = n_hidden,
                lambda = lambda, B = B, optimise = TRUE)
}

}
\references{
Wolpert D. (1992) "Stacked generalization." \emph{Neural Networks}, 5, 241-259.

Breiman L. (1996) "Stacked regressions." \emph{Machine Learning}, 24, 49-64.
}
