% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.super_RaSE.R
\name{predict.super_RaSE}
\alias{predict.super_RaSE}
\title{Predict the outcome of new observations based on the estimated super RaSE classifier (Zhu, J. and Feng, Y., 2021).}
\usage{
\method{predict}{super_RaSE}(object, newx, type = c("vote", "prob", "raw-vote", "raw-prob"), ...)
}
\arguments{
\item{object}{fitted \code{'super_RaSE'} object using \code{Rase}.}

\item{newx}{a set of new observations. Each row of \code{newx} is a new observation.}

\item{type}{the type of prediction output. Can be 'vote', 'prob', 'raw-vote' or 'raw-prob'. Default = 'vote'.
\itemize{
\item vote: output the predicted class (by voting and cut-off) of new observations. Avalilable for all base learner types.
\item prob: output the predicted probabilities (posterior probability of each observation to be class 1) of new observations. It is the average probability over all base learners.
\item raw-vote: output the predicted class of new observations for all base learners. It is a \code{n} by \code{B1} matrix. \code{n} is the test sample size and \code{B1} is the number of base learners used in RaSE. Avalilable for all base learner types.
\item raw-prob: output the predicted probabilities (posterior probability of each observation to be class 1) of new observations for all base learners. It is a \code{n} by \code{B1} matrix.
}}

\item{...}{additional arguments.}
}
\value{
depends on the parameter \code{type}. See the list above.
}
\description{
Predict the outcome of new observations based on the estimated super RaSE classifier (Zhu, J. and Feng, Y., 2021).
}
\examples{
\dontrun{
set.seed(0, kind = "L'Ecuyer-CMRG")
train.data <- RaModel("classification", 1, n = 100, p = 50)
test.data <- RaModel("classification", 1, n = 100, p = 50)
xtrain <- train.data$x
ytrain <- train.data$y
xtest <- test.data$x
ytest <- test.data$y

# fit a super RaSE classifier by sampling base learner from kNN, LDA and
# logistic regression in equal probability
fit <- Rase(xtrain = xtrain, ytrain = ytrain, B1 = 100, B2 = 100,
base = c("knn", "lda", "logistic"), super = list(type = "separate", base.update = T),
criterion = "cv", cv = 5, iteration = 1, cores = 2)
ypred <- predict(fit, xtest)
mean(ypred != ytest)
}

}
\references{
Zhu, J. and Feng, Y., 2021. Super RaSE: Super Random Subspace Ensemble Classification. https://www.preprints.org/manuscript/202110.0042
}
\seealso{
\code{\link{Rase}}.
}
