% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_stress.R
\name{stressTable}
\alias{stressTable}
\title{Get a stress table from an acmap}
\usage{
stressTable(map, optimization_number = 1)
}
\arguments{
\item{map}{The acmap object}

\item{optimization_number}{The optimization number for which to calculate
stresses}
}
\value{
Returns a matrix of stresses, showing how much each antigen and sera
measurement contributes to stress in the selected or specified
optimization.
}
\description{
Get a stress table from an acmap
}
\seealso{
Other map diagnostic functions: 
\code{\link{agCohesion}()},
\code{\link{bootstrapBlobs}()},
\code{\link{bootstrapMap}()},
\code{\link{checkHemisphering}()},
\code{\link{dimensionTestMap}()},
\code{\link{logtiterTable}()},
\code{\link{map-table-distances}},
\code{\link{mapBootstrapCoords}},
\code{\link{mapDistances}()},
\code{\link{mapRelaxed}()},
\code{\link{mapResiduals}()},
\code{\link{pointStress}},
\code{\link{ptBootstrapBlob}},
\code{\link{ptBootstrapCoords}()},
\code{\link{ptLeverage}},
\code{\link{ptTriangulationBlob}},
\code{\link{recalculateStress}()},
\code{\link{tableColbases}()},
\code{\link{tableDistances}()},
\code{\link{triangulationBlobs}()},
\code{\link{unstableMaps}}

Other functions relating to map stress calculation: 
\code{\link{logtiterTable}()},
\code{\link{mapDistances}()},
\code{\link{mapResiduals}()},
\code{\link{pointStress}},
\code{\link{recalculateStress}()},
\code{\link{tableColbases}()},
\code{\link{tableDistances}()}
}
\concept{functions relating to map stress calculation}
\concept{map diagnostic functions}
