% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{damerau_levenshtein_distance}
\alias{damerau_levenshtein_distance}
\title{Damerau-Levenshtein Distance}
\usage{
damerau_levenshtein_distance(s1, s2, score_cutoff = NULL)
}
\arguments{
\item{s1}{A string. The first input string.}

\item{s2}{A string. The second input string.}

\item{score_cutoff}{An optional maximum threshold for the distance. Defaults to the largest
integer value in R (`.Machine$integer.max`).}
}
\value{
The Damerau-Levenshtein distance as an integer.
}
\description{
Calculate the Damerau-Levenshtein distance between two strings.

Computes the Damerau-Levenshtein distance, which is an edit distance allowing transpositions in addition
to substitutions, insertions, and deletions.
}
\examples{
damerau_levenshtein_distance("abcdef", "abcfde")
damerau_levenshtein_distance("abcdef", "abcfde", score_cutoff = 3)
}
