% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{damerau_levenshtein_normalized_distance}
\alias{damerau_levenshtein_normalized_distance}
\title{Normalized Damerau-Levenshtein Distance}
\usage{
damerau_levenshtein_normalized_distance(s1, s2, score_cutoff = 1)
}
\arguments{
\item{s1}{A string. The first input string.}

\item{s2}{A string. The second input string.}

\item{score_cutoff}{An optional maximum threshold for the normalized distance. Defaults to 1.0.}
}
\value{
The normalized Damerau-Levenshtein distance as a double.
}
\description{
Calculate the normalized Damerau-Levenshtein distance between two strings.

Computes the normalized Damerau-Levenshtein distance, where the result is between
0.0 (identical) and 1.0 (completely different).
}
\examples{
damerau_levenshtein_normalized_distance("abcdef", "abcfde")
damerau_levenshtein_normalized_distance("abcdef", "abcfde", score_cutoff = 0.5)
}
