#' Draft Lottery Data
#'
#' Data from the 1970 military draft lottery. The lottery assigned numbers to
#' potential draftees by their birth date. Those with lower draft numbers were
#' drafted first.

#' @format 31 obs. of 13 variables
#' \describe{
#' \item{Day}{Day of month.}
#' \item{Jan}{Draft numbers for January birthdays by day of month.}
#' \item{Feb}{Draft numbers for February birthdays by day of month.}
#' \item{Mar}{Draft numbers for March birthdays by day of month.}
#' \item{Apr}{Draft numbers for April birthdays by day of month.}
#' \item{May}{Draft numbers for May birthdays by day of month.}
#' \item{Jun}{Draft numbers for June birthdays by day of month.}
#' \item{Jul}{Draft numbers for July birthdays by day of month.}
#' \item{Aug}{Draft numbers for August birthdays by day of month.}
#' \item{Sep}{Draft numbers for September] birthdays by day of month.}
#' \item{Oct}{Draft numbers for October birthdays by day of month.}
#' \item{Nov}{Draft numbers for November birthdays by day of month.}
#' \item{Dec}{Draft numbers for December birthdays by day of month.}
#' }
#' @note {This is the data in "draft-lottery.txt".}
#'
#' @references
#'
#' Moore, David S. and George P. McCabe (1989). Introduction to the Practice of Statistics.
#'
#' See Fienberg, S. E. (1971), Starr, N. (1997), and "Draft Lottery (1969)", Wikipedia.org for further discussion.
#'
#'
#'
"draftlottery"
