% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{effect.hetprob}
\alias{effect.hetprob}
\alias{summary.effect.hetprob}
\alias{print.effect.hetprob}
\alias{print.summary.effect.hetprob}
\title{Get average marginal effects for heterokedastic binary models}
\usage{
\method{effect}{hetprob}(object, vcov = NULL, digits = max(3, getOption("digits") - 2), ...)

\method{summary}{effect.hetprob}(object, ...)

\method{print}{effect.hetprob}(x, ...)

\method{print}{summary.effect.hetprob}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{object}{an object of class \code{hetprob} and \code{effect.hetprob} for \code{summary} and \code{print} method.}

\item{vcov}{an estimate of the asymptotic variance-covariance matrix of the parameters for a \code{hetprob} object.}

\item{digits}{the number of digits.}

\item{...}{further arguments.Ignored.}

\item{x}{an object of class \code{effect.hetprob}.}
}
\value{
An object of class \code{effect.heprob}.
}
\description{
Obtain the average marginal effects from \code{hetprob} class model.
}
\details{
This function allows to obtain the average marginal effects (not the marginal effects at the mean). The standard errors are computed using Delta Method.
}
\examples{
\donttest{
# Data
library("AER")
data("PSID1976")
PSID1976$lfp  <- as.numeric(PSID1976$participation == "yes")
PSID1976$kids <- with(PSID1976, factor((youngkids + oldkids) > 0,
                                      levels = c(FALSE, TRUE), 
                                      labels = c("no", "yes")))
                                      PSID1976$finc <-  PSID1976$fincome / 10000
                                 
# Average marginal effects for heteroskedastic Probit model
labor_het <- hetprob(lfp ~  age + I(age^2) + finc + education + factor(kids) | 
                            factor(kids) + finc,              
                     data = PSID1976,                        
                     link = "probit")
eff_labor_het <- effect(labor_het)
summary(eff_labor_het)
}
}
\author{
Mauricio Sarrias.
}
