% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorMaps.R
\name{colorMap1}
\alias{colorMap1}
\alias{colorMap2}
\alias{colorMap3}
\alias{colorMap4}
\alias{colorMap5}
\alias{colorMap6}
\alias{colorMap7}
\alias{colorMap8}
\alias{colorMap9}
\alias{colorMap10}
\alias{colorMap11}
\alias{colorMap12}
\alias{colorMap13}
\alias{colorMap14}
\title{Color mappings functions}
\usage{
colorMap1(
  Z,
  bkgcolor = "#15191e",
  nancolor = "#000000",
  reverse = c(FALSE, FALSE, FALSE),
  nthreads = 1L
)

colorMap2(
  Z,
  bkgcolor = "#15191e",
  nancolor = "#000000",
  reverse = c(FALSE, FALSE, FALSE),
  nthreads = 1L
)

colorMap3(
  Z,
  bkgcolor = "#15191e",
  nancolor = "#000000",
  s = 80,
  n = 5,
  nthreads = 1L
)

colorMap4(
  Z,
  bkgcolor = "#15191e",
  nancolor = "#000000",
  reverse = c(FALSE, FALSE, FALSE),
  nthreads = 1L
)

colorMap5(
  Z,
  bkgcolor = "#15191e",
  nancolor = "#000000",
  reverse = c(FALSE, FALSE, FALSE),
  nthreads = 1L
)

colorMap6(
  Z,
  bkgcolor = "#15191e",
  nancolor = "#000000",
  reverse = c(FALSE, FALSE, FALSE),
  nthreads = 1L
)

colorMap7(
  Z,
  bkgcolor = "#15191e",
  nancolor = "#000000",
  reverse = c(FALSE, FALSE, FALSE),
  nthreads = 1L
)

colorMap8(
  Z,
  bkgcolor = "#15191e",
  nancolor = "#000000",
  reverse = c(FALSE, FALSE, FALSE),
  nthreads = 1L
)

colorMap9(
  Z,
  bkgcolor = "#15191e",
  nancolor = "#000000",
  reverse = c(FALSE, FALSE, FALSE),
  nthreads = 1L
)

colorMap10(
  Z,
  bkgcolor = "#15191e",
  nancolor = "#000000",
  reverse = c(FALSE, FALSE, FALSE),
  nthreads = 1L
)

colorMap11(
  Z,
  bkgcolor = "#15191e",
  nancolor = "#000000",
  reverse = c(FALSE, FALSE, FALSE),
  nthreads = 1L
)

colorMap12(
  Z,
  bkgcolor = "#15191e",
  nancolor = "#000000",
  reverse = c(FALSE, FALSE, FALSE),
  nthreads = 1L
)

colorMap13(
  Z,
  bkgcolor = "#15191e",
  nancolor = "#000000",
  reverse = c(FALSE, FALSE, FALSE),
  nthreads = 1L
)

colorMap14(
  Z,
  bkgcolor = "#15191e",
  nancolor = "#000000",
  reverse = c(FALSE, FALSE, FALSE),
  nthreads = 1L
)
}
\arguments{
\item{Z}{complex number, vector or matrix}

\item{bkgcolor}{background color; it is applied for the \code{NA} values 
of \code{Z}}

\item{nancolor}{color for infinite and \code{NaN} values}

\item{reverse}{logical vector of length three; for each component of the
color space (e.g. R, G, B or H, S, L), whether to reverse it (e.g. 
\code{R -> 255-R})}

\item{nthreads}{number of threads used for parallel computation}

\item{s}{saturation, a number between 0 and 100}

\item{n}{number of rays drawn in a cycle; it should be a positive integer 
but any non-zero numeric value is accepted}
}
\value{
A string or a character vector or a character matrix, 
  having the same size as \code{Z}. Each entry is a color given 
  by a hexadecimal string.

\if{html}{
  \figure{ModularForm.png}{options: style="max-width: 60\%; text-align: center; display: block;"}
}
\if{latex}{
  \out{\begin{center}}\figure{ModularForm.png}\out{\end{center}}
}
}
\description{
Functions mapping each complex number to a color.
}
\examples{
library(RcppColors)

iota <- function(z){
  (z + 1i) / (1i*z + 1)
}
f <- function(z){
  q <- exp(2i * pi * z)
  r <- q - 4*q^2 + 2*q^3 + 8*q^4 - 5*q^5 - 8*q^6 + 6*q^7 - 23*q^9
  r / Mod(r)
}
g <- function(z){
  ifelse(
    Mod(z) >= 1, 
    NA_complex_,
    f(iota(Conj(z)))
  )
}

x <- y <- seq(-1, 1, len = 1500)
W <- outer(y, x, function(x, y) complex(real = x, imaginary = y))
Z <- g(W)
image <- colorMap1(Z)

opar <- par(mar = c(0,0,0,0), bg = "#15191E")
plot(
  c(-100, 100), c(-100, 100), type = "n", 
  xlab = "", ylab = "", axes = FALSE, asp = 1
)
rasterImage(image, -100, -100, 100, 100)
par(opar)
}
