% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fastLogisticModel}
\alias{fastLogisticModel}
\title{Logistic Regression Fitting Using L-BFGS Algorithm}
\usage{
fastLogisticModel(X, y)
}
\arguments{
\item{X}{The model matrix.}

\item{y}{The response vector.}
}
\value{
A list of L-BFGS optimization result.
}
\description{
This function leverage \code{blaze} and \code{LBFGS-Blaze} to efficiently fit logistic regression.
}
\examples{
X <- matrix(rnorm(5000), 1000)
coef <- runif(5, -3, 3)
y <- sapply(1 / (1 + exp(-X \%*\% coef)), function(p) rbinom(1, 1, p), USE.NAMES = FALSE)

fit <- fastLogisticModel(X, y)
}
