% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imperfect_competition.R
\name{cournot_solver}
\alias{cournot_solver}
\title{Cournot Duopoly with numeric solution}
\usage{
cournot_solver(firm1 = c(0, 1, 0), firm2 = c(0, 1, 0), demand = c(0,
  -1, 0))
}
\arguments{
\item{firm1}{a vector of cost curve coefficients, which must be in order: intercept of firm 1's cost function, linear term's parameter of firm 1's cost function and quadratic term's parameter of firm 1's cost function}

\item{firm2}{a vector of cost curve coefficients, which must be in order: intercept of firm 2's cost function, linear term's parameter of firm 2's cost function and quadratic term's parameter of firm 2's cost function}

\item{demand}{a vector of demand curve coefficients, which must be in order: intercept of inverse demand function, linear coefficient, secon degree coefficient}
}
\value{
List with market price, firm output, profits and market share
}
\description{
This function numerically finds the equilibrium in a Cournot duopoly model with quadratic functions. For guaranteed existence of equilibrium, cost parameters should be non-negative.
}
\examples{

d = c(20,-1,0)
cournot_solver(demand = d)

}
\author{
Diego S. Cardoso, Dyson School of Applied Economics & Management, Cornell University \email{mail@diegoscardoso.com}
}
