% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change.point.R
\name{change.point}
\alias{change.point}
\title{Change-point Detection Tests Based on Records}
\usage{
change.point(
  X,
  weights = function(t) 1,
  record = c("upper", "lower", "d", "s"),
  correct = c("none", "fisher", "vrbik"),
  permutation.test = FALSE,
  simulate.p.value = FALSE,
  B = 1000
)
}
\arguments{
\item{X}{A numeric vector, matrix (or data frame).}

\item{weights}{A function indicating the weight given to the different 
records according to their position in the series. Castillo-Mateo (2022)
showed that the weights that get more power for this test are 
\eqn{\omega_t = \sqrt{t^2 / (t - 1)}}, i.e., 
\code{weights = function(t) ifelse(t == 1, 0, sqrt(t^2 / (t - 1)))} if
\code{record = "upper"} or \code{= "lower"}.
\eqn{\omega_t = \sqrt{t}}, i.e., \code{weights = function(t) sqrt(t)} if
\code{record = "d"} and \eqn{\omega_t = \sqrt{t^2 / (t-2)}}, i.e., 
\code{weights = function(t) ifelse(t \%in\% 1:2, 0, sqrt(t^2 / (t-2)))} if
\code{record = "s"}.}

\item{record}{A character string that indicates the type of statistic used.
The statistic with \code{"upper"} or \code{= "lower"} records, or the 
statistic with the difference, \code{"d"}, or the sum, \code{"s"}, of 
upper and lower records.}

\item{correct}{A character string that indicates the continuity correction
in the Kolmogorov distribution made to the statistic: "fisher" (Fisher and
Robbins 2019), "vrbik" (Vrbik 2020) or "none" (the default) if no 
correction is made. The former shows better size and power, but if the 
value of the statistic is too large it becomes \code{NaN} and p-value 
\code{NA}.}

\item{permutation.test}{Logical. Indicates whether to compute p-values by
permutation simulation (Castillo-Mateo et al. 2023). It does not require 
that the columns of \code{X} be independent. If \code{TRUE} and 
\code{simulate.p.value = TRUE}, permutations take precedence and 
permutations are performed.}

\item{simulate.p.value}{Logical. Indicates whether to compute p-values by
Monte Carlo simulation. If \code{permutation.test = TRUE}, permutations    
take precedence and permutations are performed.}

\item{B}{If \code{permutation.test = TRUE} or \code{simulate.p.value = TRUE},
an integer specifying the number of replicates used in the permutation or    
Monte Carlo estimation.}
}
\value{
A \code{"htest"} object with elements:
  \item{statistic}{Value of the test statistic.}
  \item{p.value}{P-value.}
  \item{alternative}{The alternative hypothesis.}
  \item{estimate}{The estimated change-point time.}
  \item{method}{A character string indicating the type of test performed.}
  \item{data.name}{A character string giving the name of the data.}
}
\description{
Performs change-point detection tests based on the record
  occurrence. The hypothesis of the classical record model (i.e., of IID 
  continuous RVs) is tested against the alternative hypothesis that after a 
  certain time the series stops being IID.
}
\details{
The test is implemented as given by Castillo-Mateo (2022). The null 
  hypothesis is that 
  \deqn{H_0: p_t = 1/t, \qquad t=1,\ldots,T,}
  where \eqn{p_t} is the probability of (upper and/or lower) record at time 
  \eqn{t}. The two-sided alternative hypothesis is that 
  \deqn{H_1: p_t = 1/t, \quad t=1,\ldots,t_0, \qquad p_t \neq 1/t, \quad t=t_0+1,\ldots,T,}
  for a change-point \eqn{t_0}.
  
  The variables used for the statistic are
  \deqn{K^{\omega}_T = \max_{1\le t \le T} \left| \frac{N_{t}^{\omega} - \textrm{E}(N_{t}^{\omega})}{\sqrt{\textrm{VAR}(N_{T}^{\omega})}} - \frac{\textrm{VAR}(N_{t}^{\omega})}{\textrm{VAR}(N_{T}^{\omega})} \frac{N_{T}^{\omega} - \textrm{E}(N_{T}^{\omega})}{\sqrt{\textrm{VAR}(N_{T}^{\omega})}} \right|,}
  where \eqn{N_{t}^\omega = \sum_{m=1}^M \sum_{j=1}^t \omega_j I_{jm}}, and
  the estimated change-point \eqn{\hat{t}_0} is the value \eqn{t} where 
  \eqn{K^{\omega}_T} attains its maximum.
  
  Argument \code{record} indicates if the \eqn{I_{tm}}'s are the 
  \code{"upper"} or \code{"lower"} record indicators (see 
  \code{\link{I.record}}). If \code{record = "d"} or \code{= "s"},
  \eqn{N_{t}^\omega} is substituted in the expressions above by 
  \eqn{d_{t}^{\omega,(F)} = N_{t}^{\omega,(FU)} - N_{t}^{\omega,(FL)}} or 
  \eqn{s_{t}^{\omega,(F)} = N_{t}^{\omega,(FU)} + N_{t}^{\omega,(FL)}}, 
  respectively.
  
  The p-value is calculated by means of the asymptotic Kolmogorov
  distribution. When \eqn{\omega_t \neq 1}, the asymptotic result is not 
  fulfilled. In that case, the p-value should be simulated using 	
  permutation or Monte Carlo simulations with the option 	
  \code{permutation.test = TRUE} or \code{simulate.p.value = TRUE}, 	
  respectively. Permutations is the only method of calculating p-values that	
  does not require that the columns of \code{X} be independent.	
  	
  As the Kolmogorov distribution is an asymptotic result, it has been seen 	
  that the size and power may be a little below than expected, to correct 	
  this, any of the continuity corrections can be used:
  
  If \code{correct = "fisher"},
  \deqn{K_T = - \sqrt{T} \log\left(1 - \frac{K_T}{\sqrt{T}}\right).}
  
  If \code{correct = "vrbik"},
  \deqn{K_T = K_T + \frac{1}{6\sqrt{T}} + \frac{K_T - 1}{4T}.}
}
\examples{
change.point(ZaragozaSeries)

change.point(series_split(TX_Zaragoza$TX), record = "d", 	
  weights = function(t) sqrt(t), 
  permutation.test = TRUE, B = 50)

change.point(ZaragozaSeries, record = "d", 
  weights = function(t) sqrt(t), simulate.p.value = TRUE)

test.result <- change.point(rowMeans(ZaragozaSeries))
test.result

## Not run: Load package ggplot2 to plot the changepoint
#library("ggplot2")
#records(rowMeans(ZaragozaSeries)) + 
#  ggplot2::geom_vline(xintercept = test.result$estimate, colour = "red")

}
\references{
Castillo-Mateo J (2022).
“Distribution-Free Changepoint Detection Tests Based on the Breaking of Records.”
\emph{Environmental and Ecological Statistics}, \strong{29}(3), 655-676.
\doi{10.1007/s10651-022-00539-2}.

Castillo-Mateo J, Cebrián AC, Asín J (2023).
“Statistical Analysis of Extreme and Record-Breaking Daily Maximum Temperatures in Peninsular Spain during 1960--2021.”
\emph{Atmospheric Research}, \strong{293}, 106934.
\doi{10.1016/j.atmosres.2023.106934}.

Fisher TJ, Robbins MW (2019). 
“A Cheap Trick to Improve the Power of a Conservative Hypothesis Test.”
\emph{The American Statistician}, \strong{73}(3), 232-242.
\doi{10.1080/00031305.2017.1395364}.

Vrbik J (2020). 
“Deriving CDF of Kolmogorov-Smirnov Test Statistic.”
\emph{Applied Mathematics}, \strong{11}(3), 227-246.
\doi{10.4236/am.2020.113018}.
}
\seealso{
\code{\link{records}}, \code{\link{foster.test}}
}
\author{
Jorge Castillo-Mateo
}
