% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilidades.R
\name{Bochsler}
\alias{Bochsler}
\title{Utilities. Get data for Bochsler method (2010)}
\usage{
Bochsler(Ano, Mes, RutaDescarga, RutaSalida)
}
\arguments{
\item{Ano}{This value corresponds to the year of the data that the user wants to download.
This data can be numerical or character (numerical is preferred).}

\item{Mes}{This is the month in which the election was held. It must be a character
with two digits, i.e. "04" is valid but "4" is not.}

\item{RutaDescarga}{A path to the local hard disk where the Ministry of the Interior's Excel
file will be downloaded must be indicated. Once the download is completed the downloaded
file will be automatically deleted.}

\item{RutaSalida}{It is a path of the local hard disk where the Excel sheet generated with
the data will be deposited to feed Daniel Bochsler's macro. The resulting Excel workbook
is called 'Bochsler.xlsx'.}
}
\value{
With this function you obtain an Excel sheet called 'Bochsler.xlsx' placed in the
route that has been indicated with the parameter 'RutaSalida'.
}
\description{
The standardised party nationalisation index developed by Bochsler (2010)
can be calculated using an excel spreadsheet, which can be downloaded from the following
website: \url{https://www.bochsler.eu/pns/}. This Excel file
contains a macro to calculate the match nationalisation index, which is widely used
nowadays. The aim of this function is to create an Excel sheet that
is directly loaded with the data provided by the Spanish Ministry of the Interior (MIR),
\url{http://www.infoelectoral.mir.es/}.
This data is arranged in such a way that it is only necessary to copy and paste it into
the macro created by Bochsler. This makes it much easier to load the macro function with
data. In the Excel sheet that is created, the last row contains the totals that are the
ones to be placed in row 8 of Daniel Bochsler's macro function.
}
\section{Utilities}{
NA
}

\examples{

Bochsler(2019,"04","F:/","F:/")
Bochsler(2016,"06","F:/","F:/")

}
