% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgDep3.R
\name{getDeps}
\alias{getDeps}
\title{The \code{packages} argument may have up to 4 pieces of information for GitHub
packages: name, repository, branch, version. For CRAN-alikes, it will only
be 2 pieces: name, version. There can also be an inequality or equality, if
there is a version.}
\usage{
getDeps(pkgDT, which, recursive, type = type, repos, libPaths, verbose)
}
\arguments{
\item{pkgDT}{A \code{pkgDT} object e.g., from \code{toPkgDT}}

\item{which}{a character vector listing the types of dependencies, a subset
of \code{c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}.
Character string \code{"all"} is shorthand for that vector, character string
\code{"most"} for the same vector without \code{"Enhances"}.}

\item{recursive}{Logical. Should dependencies of dependencies be searched,
recursively. NOTE: Dependencies of suggests will not be recursive. Default
\code{TRUE}.}

\item{type}{See \code{utils::install.packages}}

\item{repos}{is used for \code{ap}.}

\item{libPaths}{A path to search for installed packages. Defaults to
\code{.libPaths()}}

\item{verbose}{Numeric or logical indicating how verbose should the function
be. If -1 or -2, then as little verbosity as possible. If 0 or FALSE,
then minimal outputs; if \code{1} or TRUE, more outputs; \code{2} even more. NOTE: in
\code{Require} function, when \code{verbose >= 2}, also returns details as if
\code{returnDetails = TRUE} (for backwards compatibility).}
}
\value{
A (named) vector of SaveNames, which is a concatenation of the 2 or 4 elements
above, plus the \code{which} and the \code{recursive}.
}
\description{
The \code{packages} argument may have up to 4 pieces of information for GitHub
packages: name, repository, branch, version. For CRAN-alikes, it will only
be 2 pieces: name, version. There can also be an inequality or equality, if
there is a version.
}
\details{
If version is not supplied, it will take the local, installed version, if it
exists. Otherwise, it is assumed that the HEAD is desired.
The function will find it in the \code{ap} or on \code{github.com}. For github packages,
this is obviously a slow step, which can be accelerated if user supplies a sha
or a version e.g., getDeps("PredictiveEcology/LandR@development (==1.0.2)")
}
