% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.model.R
\name{fit.model}
\alias{fit.model}
\title{Function to fit the MFDFA result with the extended binomial multifractal model.}
\usage{
fit.model(Hq, q)
}
\arguments{
\item{Hq}{a nurmeric vector for the generalized Hurst exponent.}

\item{q}{a vector of integers, q-order of the moment.}
}
\value{
a vector for fitting parameters."a" and "b" is the coefficients of the extended binomial multifractal model.
"Goodness" is the goodness of fit
}
\description{
function to fit the result of Multifractal detrended fluctuation analysis (MFDFA) with the extended binomial multifractal model.
Return the results as a vector which contain the parameters of the model and the goodness of fit
}
\examples{
data("TestData") # load Data from TestData dataset
Fs=50 ## sampling frequency is 50Hz
Peaks=find.peaks(Data[,2],Fs)
PP_interval=diff(Peaks[,1])/Fs
exponents=seq(3, 8, by=1/4)
scale=2^exponents
q=-10:10
m=2
Result <- MFDFA(PP_interval, scale, m, q)
Coeff <- fit.model(Result$Hq,q)
Coeff
}
\references{
Zhang T, Dong X, Chen C, Wang D, Zhang XD. RespirAnalyzer: an R package for continuous monitoring of respiratory signals.
}
