% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readTrees.R
\name{readTrees}
\alias{readTrees}
\title{Read trees}
\usage{
readTrees(paths, tree_name = "psi", burnin = 0, n_cores = 1L, verbose = TRUE)
}
\arguments{
\item{paths}{(vector of character strings; no default) File path(s) to
tree(s).}

\item{tree_name}{(character string; default psi) Name of the tree variable.}

\item{burnin}{(single numeric value; default = 0.1) Fraction of generations
to discard (if value provided is between 0 and 1) or number of generations
(if value provided is greater than 1).}

\item{n_cores}{(integer; default 1) Number of cores for parallelizing.}

\item{verbose}{(logical; default true) Display a status bar?}
}
\value{
A list (across runs) of lists (across samples) of treedata objects.
}
\description{
Reads in a tree file containing one or multiple trees
}
\details{
Reads in a tree file in either nexus or newick format, and containing a
single tree or multiple trees (as in the results of a Bayesian analysis).
For reading in annotated tree files of continuous character evolution,
the parameter must be considered a node parameter rather than branch
parameter. Set isNodeParameter = TRUE in the extended newick monitor
(mnExtNewick)
}
\examples{

\donttest{
# read in a single nexus file

# download the example dataset to working directory
url_nex <-
 "https://revbayes.github.io/tutorials/intro/data/primates_cytb_GTR_MAP.tre"
dest_path_nex <- "primates_cytb_GTR_MAP.tre"
download.file(url_nex, dest_path_nex)

# to run on your own data, change this to the path to your data file
file <- dest_path_nex
tree_single_old <- readTrees(paths = file)

# remove file
# WARNING: only run for example dataset!
# otherwise you might delete your data!
file.remove(dest_path_nex)

# read in a single newick string

# download the example dataset to working directory
url_new <-
 "https://revbayes.github.io/tutorials/intro/data/primates.tre"
dest_path_new <- "primates.tre"
download.file(url_new, dest_path_new)

# to run on your own data, change this to the path to your data file
file_new <- dest_path_new
tree_new <- readTrees(paths = file_new)

# remove file
# WARNING: only run for example dataset!
# otherwise you might delete your data!
file.remove(dest_path_new)


# read in a tree trace (may take a few seconds)

# download the example dataset to working directory
url_multi <-
 "https://revbayes.github.io/tutorials/intro/data/primates_cytb_GTR.trees"
dest_path_multi <- "primates_cytb_GTR.trees"
download.file(url_multi, dest_path_multi)

# to run on your own data, change this to the path to your data file
file_multi <- dest_path_multi
tree_multi <- readTrees(paths = file_multi)

# remove file
# WARNING: only run for example dataset!
# otherwise you might delete your data!
file.remove(dest_path_multi)
}

}
