% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IEX_Market_Data.R
\name{iex.intraday}
\alias{iex.intraday}
\title{Returns 1 minute bar data where open, high, low, and close are per minute. For latest stock price use the iex.quote function}
\usage{
iex.intraday(x, iex_sk)
}
\arguments{
\item{x}{A character vector that can include one or multiple  Tickers / Stocks Symbols}

\item{iex_sk}{is a character vector that include IEX Cloud API Secret Token}
}
\value{
Data frame that includes stock (s) financial data
}
\description{
For more details, visit:\url{https://iexcloud.io/docs/api/#historical-prices}
}
\examples{
\dontrun{
  iex.intraday ("TSLA", "sk")
}
}
\seealso{
Investors Exchange `IEX` developer guide \url{https://iexcloud.io/docs/api/}

Investors Exchange Group (IEX Group) offers flexible and salable pricing.\url{https://iexcloud.io/pricing/}

View Investors Exchange Group (IEX Group) terms of use and subscription levels.\url{https://iexcloud.io/terms/}

Package `iexcloudR`\url{https://github.com/schardtbc/iexcloudR}
}
\author{
Myriam Ibrahim
}
