% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canada.R
\name{canada}
\alias{canada}
\title{canada}
\usage{
canada(
  site,
  variable = "discharge",
  start_date = NULL,
  end_date = NULL,
  sites = FALSE,
  ...
)
}
\arguments{
\item{site}{Canadian gauge number}

\item{variable}{Character. Either \code{stage} or \code{discharge}.}

\item{start_date}{Character. Optional start date with format
YYYY-MM-DD. Default is 1900-01-01.}

\item{end_date}{Character. End date with format YYYY-MM-DD.
Default is the current date.}

\item{sites}{Logical. If TRUE, returns a list of measurement
sites.}

\item{...}{Additional arguments. None implemented.}
}
\value{
data frame of discharge time-series
}
\description{
Retrieve Canadian gauge data
}
\examples{
\dontrun{
#For the first time, you must run:
tidyhydat::download_hydat()
df = canada("01AD003")
plot(df$Date, df$Q, type='l')
}
}
