% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Analyses_functions_1.R
\name{sojourn}
\alias{sojourn}
\title{Estimated sojourn measure}
\usage{
sojourn(X, A, N = 10000, level = "greater", subI = NULL, plot = FALSE)
}
\arguments{
\item{X}{Data frame where the first column is a numeric time sequence \eqn{t}
and the second one is the values of the time series \eqn{X(t)}.}

\item{A}{Constant level as a numeric value.}

\item{N}{Number of steps on the time interval (or time sub-interval) used for computations. Default set to 10000.}

\item{level}{A vector of character strings which specifies which sojourn
measure required for \code{X}, \code{"greater"} or \code{"lower"} than \code{A}. Default set to \code{"greater"}.}

\item{subI}{Time sub-interval is a vector, where the lower bound is
the first element and the upper bound is the second. Optional: If provided,
the estimated sojourn measure for the sub-interval is returned, otherwise the whole time interval is considered.}

\item{plot}{Logical: If \code{TRUE}, the time series, constant level (in blue) and the sojourn measure (in red) are plotted
in interactive sessions.}
}
\value{
Estimated sojourn measure.
}
\description{
Computes the estimated sojourn measure for a time series \eqn{X(t)} greater or lower than the
constant level \code{A} for the provided time interval or its sub-interval.
}
\examples{
t <- seq(0, 1, length = 1000)
TS <- data.frame("t" = t,"X(t)" = rnorm(1000))
sojourn(TS, 0.8, level = 'lower',subI = c(0.5, 0.8), plot = TRUE)
}
\seealso{
\code{\link{exc_Area}}
}
