% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnvd3.R
\name{lineChart}
\alias{lineChart}
\title{Line chart}
\usage{
lineChart(
  data,
  xAxisTitle = "x",
  yAxisTitle = "y",
  margins = list(l = 90),
  duration = 500,
  useInteractiveGuideline = TRUE,
  xAxisTickFormat = ".0f",
  yAxisTickFormat = ".02f",
  xLabelsFontSize = "0.75rem",
  yLabelsFontSize = "0.75rem",
  legendPosition = "top",
  interpolate = "linear",
  xRange = NULL,
  yRange = NULL,
  rightAlignYaxis = FALSE,
  tooltipFormatters = list(value = NULL, header = NULL, key = NULL),
  tooltipTransitions = TRUE,
  tooltipShadow = TRUE,
  width = "100\%",
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{data}{data used for the chart; it must be a list created with
\code{\link{lineChartData}}, or a list of such lists (for multiple lines)}

\item{xAxisTitle}{string, the title of the x-axis}

\item{yAxisTitle}{string, the title of the y-axis}

\item{margins}{a named list defining the margins, with names \code{"t"},
\code{"r"}, \code{"b"} and \code{"l"}, for "top", "right", "bottom"
and "left" respectively; you can specify only certain margins in the list
to change just those parts}

\item{duration}{transition duration in milliseconds}

\item{useInteractiveGuideline}{Boolean, a guideline and synchronized tooltips}

\item{xAxisTickFormat}{a d3 formatting string for the ticks on the x-axis;
a d3 \emph{time} formatting string if the x-values are dates, see
\href{https://github.com/d3/d3-time-format/blob/v3.0.0/README.md#locale_format}{d3.time.format}}

\item{yAxisTickFormat}{a d3 formatting string for the ticks on the y-axis}

\item{xLabelsFontSize}{a CSS measure, the font size of the labels on the
x-axis}

\item{yLabelsFontSize}{a CSS measure, the font size of the labels on the
y-axis}

\item{legendPosition}{string, the legend position, \code{"top"} or
\code{"right"}}

\item{interpolate}{interpolation type, a string among \code{"linear"},
\code{"step-before"}, \code{"step-after"}, \code{"basis"},
\code{"basis-open"}, \code{"basis-closed"}, \code{"bundle"},
\code{"cardinal"}, \code{"cardinal-open"}, \code{"cardinal-closed"},
\code{"monotone"}}

\item{xRange}{the x-axis range, a length two vector of the same type as the
x-values, or \code{NULL} to derive it from the data}

\item{yRange}{the y-axis range, a numeric vector of length 2, or
\code{NULL} to derive it from the data}

\item{rightAlignYaxis}{Boolean, whether to put the y-axis on the right side
instead of the left}

\item{tooltipFormatters}{formatters for the tooltip; each formatter must
be \code{NULL} for the default formatting, otherwise a JavaScript function
created with \code{\link{JS}}; there are three possible formatters
(see the example):
\describe{
  \item{value}{formatter for the y-value displayed in the tooltip}
  \item{header}{formatter for the tooltip header (this is the x-value)}
  \item{key}{formatter for the value of the 'by' variable}
}}

\item{tooltipTransitions}{Boolean, whether to style the tooltip with a
fade effect}

\item{tooltipShadow}{Boolean, whether to style the tooltip with a shadow}

\item{width}{width of the chart container, must be a valid CSS measure}

\item{height}{height of the chart container, must be a valid CSS measure}

\item{elementId}{an id for the chart container, usually useless}
}
\value{
A HTML widget displaying a line chart.
}
\description{
Create a HTML widget displaying a line chart.
}
\examples{
library(Rnvd3)

dat1 <-
  lineChartData(x = ~ 1:100, y = ~ sin(1:100/10), key = "Sine wave", color = "lime")
dat2 <-
  lineChartData(x = ~ 1:100, y = ~ sin(1:100/10)*0.25 + 0.5,
                key = "Another sine wave", color = "red")
dat <- list(dat1, dat2)

lineChart(dat)

# with a date x-axis ####
dat1 <-
  lineChartData(
    x = ~ Sys.Date() + 1:100, y = ~ sin(1:100/10), key = "Sine wave", color = "lime"
  )
dat2 <-
  lineChartData(x = ~ Sys.Date() + 1:100, y = ~ sin(1:100/10)*0.25 + 0.5,
                key = "Another sine wave", color = "darkred")
dat <- list(dat1, dat2)

lineChart(
  dat,
  margins = list(t = 100, r = 100, b = 100, l = 100),
  xAxisTickFormat = "\%Y-\%m-\%d"
)

# with a datetime x-axis

dat <- data.frame(
  x  = Sys.time() + (1:300),
  y1 = sin(1:300/10),
  y2 = sin(1:300/10)*0.25 + 0.5
)
dat1 <-
  lineChartData(x = ~x, y = ~y1, data = dat, key = "Sine wave", color = "lime")
dat2 <-
  lineChartData(x = ~x, y = ~y2, data = dat,
                key = "Another sine wave", color = "darkred")
dat12 <- list(dat1, dat2)

lineChart(
  dat12,
  margins = list(t = 100, r = 100, b = 100, l = 100),
  xAxisTickFormat = "\%H:\%M:\%S",
  xAxisTitle = "Time", yAxisTitle = "Energy"
)
}
