% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmrobdet.R
\name{lmrobM.control}
\alias{lmrobM.control}
\title{Tuning parameters for lmrobM}
\usage{
lmrobM.control(
  bb = 0.5,
  efficiency = 0.99,
  family = "opt",
  tuning.chi,
  tuning.psi,
  max.it = 100,
  rel.tol = 1e-07,
  mscale_tol = 1e-06,
  mscale_maxit = 50,
  trace.lev = 0
)
}
\arguments{
\item{bb}{tuning constant (between 0 and 1/2) for the M-scale used to compute the residual
scale estimator. Defaults to 0.5.}

\item{efficiency}{desired asymptotic efficiency of the final regression M-estimator. Defaults to 0.85.}

\item{family}{string specifying the name of the family of loss function to be used (current valid
options are "bisquare", "opt" and "mopt"). Incomplete entries will be matched to
the current valid options.}

\item{tuning.chi}{tuning constant for the function used to compute the M-scale
used for the residual scale estimator. If missing, it is computed inside \code{lmrobdet.control} to match
the value of \code{bb} according to the family of rho functions specified in \code{family}.}

\item{tuning.psi}{tuning parameters for the regression M-estimator computed with a rho function
as specified with argument \code{family}. If missing, it is computed inside \code{lmrobdet.control} to match
the value of \code{efficiency} according to the family of rho functions specified in \code{family}.
Appropriate values for \code{tuning.psi} for a given desired efficiency for Gaussian errors
can be constructed using the functions \link{bisquare}, \link{mopt} and \link{opt}.}

\item{max.it}{maximum number of IRWLS iterations for the M-estimator}

\item{rel.tol}{relative covergence tolerance for the IRWLS iterations for the M-estimator}

\item{mscale_tol}{Convergence tolerance for the M-scale algorithm. See \code{\link{scaleM}}.}

\item{mscale_maxit}{Maximum number of iterations for the M-scale algorithm. See \code{\link{scaleM}}.}

\item{trace.lev}{positive values (increasingly) provide details on the progress of the M-algorithm}
}
\value{
A list with the necessary tuning parameters.
}
\description{
This function sets tuning parameters for the M estimators of regression implemented
in \code{\link{lmrobM}}.
}
\examples{
data(coleman, package='robustbase')
m2 <- lmrobM(Y ~ ., data=coleman, control=lmrobM.control())
m2
summary(m2)

}
\author{
Matias Salibian-Barrera, \email{matias@stat.ubc.ca}
}
