% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuneandtrainRobustTuneC.R
\name{tuneandtrainRobustTuneC}
\alias{tuneandtrainRobustTuneC}
\title{Tune and Train Classifier by Tuning Method RobustTuneC}
\usage{
tuneandtrainRobustTuneC(data, dataext, classifier, ...)
}
\arguments{
\item{data}{A data frame containing the training data. The first column should be the response variable (factor), 
and the remaining columns should be the predictor variables.}

\item{dataext}{A data frame containing the external validation data. The first column should be the 
response variable (factor), and the remaining columns should be the predictor variables.}

\item{classifier}{A character string specifying the classifier to use. Must be one of the following:
\itemize{
  \item "boosting" for Boosting classifiers.
  \item "rf" for Random Forest.
  \item "lasso" for Lasso regression.
  \item "ridge" for Ridge regression.
  \item "svm" for Support Vector Machines.
}}

\item{...}{Additional arguments to pass to the specific classifier function.}
}
\value{
A list containing the results from the specific classifier's tuning and training process, 
  the returned object typically includes:
  \itemize{
    \item \code{best_hyperparams}: The best hyperparameters selected through the RobustTuneC method.
    \item \code{best_model}: The final trained model based on the best hyperparameters.
    \item \code{final_auc}: Performance metrics (AUC) of the final model.
  }
}
\description{
This function tunes and trains a specified classifier using the "RobustTuneC" method and the provided data.
}
\examples{
# Load sample data
data(sample_data_train)
data(sample_data_extern)

# Example usage with Lasso
result_lasso <- tuneandtrainRobustTuneC(sample_data_train, sample_data_extern, classifier = "lasso",
  maxit = 120000, nlambda = 100)
result_lasso$best_lambda
result_lasso$best_model
result_lasso$final_auc
result_lasso$active_set_Train

# Example usage with Ridge
result_ridge <- tuneandtrainRobustTuneC(sample_data_train, sample_data_extern, 
  classifier = "ridge", maxit = 120000, nlambda = 100)
result_ridge$best_lambda
result_ridge$best_model
result_ridge$final_auc
}
