% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FeatureSelection.R
\name{FS.reduct.computation}
\alias{FS.reduct.computation}
\title{The reduct computation methods based on RST and FRST}
\usage{
FS.reduct.computation(decision.table, method = "greedy.heuristic", ...)
}
\arguments{
\item{decision.table}{an object of a \code{"DecisionTable"} class representing a decision table. See \code{\link{SF.asDecisionTable}}.}

\item{method}{a character representing the type of computation method to use. See in Section \code{Details}.}

\item{...}{other parameters. See the parameters of \code{\link{FS.greedy.heuristic.reduct.RST}}, \code{\link{FS.DAAR.heuristic.RST}},
\code{\link{FS.nearOpt.fvprs.FRST}} and \code{\link{FS.permutation.heuristic.reduct.RST}}.}
}
\value{
An object of a class \code{"FeatureSubset"}. See \code{\link{FS.greedy.heuristic.reduct.RST}},
\code{\link{FS.DAAR.heuristic.RST}}, \code{\link{FS.permutation.heuristic.reduct.RST}} or
\code{\link{FS.nearOpt.fvprs.FRST}} for more details.
}
\description{
This function is a wrapper for computing different types of decision reducts
and approximate decision reducts.
}
\details{
The implemented methods include the following approaches:
\itemize{
\item \code{"greedy.heuristic"}: a greedy heuristic method for computation of decision reducts (or approximate decision reducts) based on RST.
                                 See \code{\link{FS.greedy.heuristic.reduct.RST}}.

\item \code{"DAAR.heuristic"}: Dynamically Adapted Approximate Reduct heuristic, which is a modification of the greedy heuristic with a random probe test to avoid inclusion of irrelevant attributes to the reduct.
                              See \code{\link{FS.DAAR.heuristic.RST}}.

\item \code{"nearOpt.fvprs"}: the near-optimal reduction algorithm based on FRST.
                              See \code{\link{FS.nearOpt.fvprs.FRST}}.

\item \code{"permutation.heuristic"}: a permutation-based elimination heuristic for computation of decision reducts based on RST.
                                      See \code{\link{FS.permutation.heuristic.reduct.RST}}.
}
Those methods can be selected by setting the parameter \code{method}.
Additionally, \code{\link{SF.applyDecTable}} has been provided to generate a new decision table.
}
\examples{
##############################################################
## Example 1: generate reduct and new decision table
## using RST and FRST
##############################################################
data(RoughSetData)
decision.table <- RoughSetData$hiring.dt

## generate a single reduct using RST
reduct.1 <- FS.reduct.computation(decision.table, method = "greedy.heuristic")

## generate a single reduct using FRST
reduct.2 <- FS.reduct.computation(decision.table, method = "nearOpt.fvprs")

## generate a new decision table using reduct.1
new.decTable.1 <- SF.applyDecTable(decision.table, reduct.1)

## generate new decision table using reduct.2
new.decTable.2 <- SF.applyDecTable(decision.table, reduct.2)

}
\seealso{
\code{\link{D.discretization.RST}}, \code{\link{BC.LU.approximation.RST}}
}
\author{
Andrzej Janusz
}
