% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{update_classes_wb}
\alias{update_classes_wb}
\title{Weight-based class updates}
\usage{
update_classes_wb(
  s,
  b,
  Omega,
  epsmin = 0.01,
  epsmax = 0.7,
  deltamin = 0.1,
  deltashift = 0.5,
  identify_classes = FALSE,
  Cmax = 10L
)
}
\arguments{
\item{s}{[\code{numeric(C)}]\cr
The vector of class weights.}

\item{b}{[\code{matrix(nrow = P_r, ncol = C)}]\cr
The matrix of class means as columns.}

\item{Omega}{[\code{matrix(nrow = P_r * P_r, ncol = C)}]\cr
The matrix of vectorized class covariance matrices as columns.}

\item{epsmin}{[\code{numeric(1)}]\cr
The threshold weight for removing a class.}

\item{epsmax}{[\code{numeric(1)}]\cr
The threshold weight for splitting a class.}

\item{deltamin}{[\code{numeric(1)}]\cr
The threshold difference in class means for joining two classes.}

\item{deltashift}{[\code{numeric(1)}]\cr
The scale for shifting the class means after a split.}

\item{identify_classes}{[\code{logical(1)}]\cr
Identify classes by decreasing class weights?}

\item{Cmax}{[\code{integer(1)}]\cr
The maximum number of classes, used to allocate space.}
}
\value{
A list of updated values for \code{s}, \code{b}, and \code{Omega} and
the indicator \code{update_type} which signals the type of class update:
\itemize{
\item \code{0}: no update
\item \code{1}: removed class
\item \code{2}: split class
\item \code{3}: merged classes
}
}
\description{
Weight-based class updates
}
\details{
The following updating rules apply:
\itemize{
\item Class \eqn{c} is removed if \eqn{s_c < \epsilon_{min}}.
\item Class \eqn{c} is split into two classes, if \eqn{s_c > \epsilon_{max}}.
\item Two classes \eqn{c_1} and \eqn{c_2} are merged to one class, if
\eqn{||b_{c_1} - b_{c_2}|| < \delta_{min}}.
}
}
\examples{
s <- c(0.7, 0.3)
b <- matrix(c(1, 1, 1, -1), ncol = 2)
Omega <- matrix(c(0.5, 0.3, 0.3, 0.5, 1, -0.1, -0.1, 0.8), ncol = 2)

### no update
update_classes_wb(s = s, b = b, Omega = Omega)

### remove class 2
update_classes_wb(s = s, b = b, Omega = Omega, epsmin = 0.31)

### split class 1
update_classes_wb(s = s, b = b, Omega = Omega, epsmax = 0.69)

### merge classes 1 and 2
update_classes_wb(s = s, b = b, Omega = Omega, deltamin = 3)

}
\keyword{gibbs_sampler}
