% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rprofet.R
\name{ScoreDataProfet}
\alias{ScoreDataProfet}
\title{Score a Validation Data Set}
\usage{
ScoreDataProfet(data, card, id, target)
}
\arguments{
\item{data}{The validation data set, which should be binned in the same way as the scorecard in the card argument.}

\item{card}{A ScorecardProfet object. The object should be created by using the training set split from the same dataframe
as the validation set.}

\item{id}{ID variable.}

\item{target}{A binary target variable.}
}
\value{
A dataframe of scored validation set.
}
\description{
Function that scores the validation set using the scorecard from the ScorecardProfet object created by
the training set.
}
\examples{
mydata <- ISLR::Default
mydata$ID = seq(1:nrow(mydata)) ## make the ID variable
mydata$default<-ifelse(mydata$default=="Yes",1,0) ## Creating numeric binary target variable

binned <- BinProfet(mydata, id= "ID", target= "default", num.bins = 5) ## Binning variables

WOE_dat <- WOEProfet(binned, "ID","default", 3:5) ## WOE transformation of bins

md <- glm(default ~ student_WOE+balance_WOE+income_WOE, data=WOE_dat$WOE, family="binomial")
summary(md)

Score_card <- ScorecardProfet(object=WOE_dat, id="ID", target="default", GLModel=md,
                                 PDO = 50, BaseOdds = 10, BasePts = 1000, reverse = FALSE)
Score_card ## scorecard

## Scoring the data
# variable names needs to be the same as the Attributes on scorecard
colnames(binned)
colnames(binned)[3:5] <- c("student", "balance", "income") #change the variable name
Score_dat = ScoreDataProfet(data=binned, card=Score_card, id="ID", target="default") #scoring data
head(Score_dat)
}
