% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rprofet.R
\name{WOE_customFac}
\alias{WOE_customFac}
\title{Custom Binning Factor Variables}
\usage{
WOE_customFac(
  data,
  var,
  id,
  target,
  new_levels,
  color = "#0066CC",
  plot = FALSE
)
}
\arguments{
\item{data}{Dataframe containing the target variable and desired factor variables to be binned.}

\item{var}{A specific factor attribute to be binned.}

\item{id}{The unique id variable in the dataframe. Must be specified.}

\item{target}{A binary target variable. Must be specified.}

\item{new_levels}{A vector the same length as the number of levels for the categorical variable containing the new factor levels. Must be specified.}

\item{color}{A hexadecimal value representing a specific color.}

\item{plot}{Logical. The default is FALSE which does not generate the plots.}
}
\value{
A list with the following components.
\item{NewBin}{Dataframe with the binned variable.}
\item{BinWOE}{Dataframe with target, binned variable, and WOE values for the bins.}
\item{IV}{Information value of the newly binned variable.}
\item{vars}{Dataframe with binned variable, WOE values for the bins, Target Rate for each bin, and observation count for each bin.}
}
\description{
Function that bins a factor variable based on user inputted factor levels, plots the information on the new bins,
and returns a list contains a dataframe of the newly binned values and id column and more items.
}
\examples{
mydata <- ISLR::Default
mydata$ID = seq(1:nrow(mydata)) ## make the ID variable
mydata$default <- ifelse(mydata$default=="Yes", 1, 0) ## target coded with 1, 0
## WOE_customFactor
custom1 <- WOE_customFac(data=mydata, var="student", id ="ID", target="default",
                         new_levels=c("Student : No","Student : Yes"))
head(custom1$NewBin)
head(custom1$BinWOE)
custom1$IV
custom1$vars
## --------------------------
mydata$balance_cat <- cut(mydata$balance, breaks = c(-1,400,800,1200,1600,2000,2400,2800),
                          labels = c("Very-Low","Low","Med-Low","Med",
                          "Med-High","High","Very-High"))
custom2 <- WOE_customFac(data=mydata, var="balance_cat", id ="ID", target="default",
                         new_levels=c(1,1,2,2,2,3,3))
head(custom2$NewBin)
head(custom2$BinWOE)
custom2$IV
custom2$vars
}
