\name{plotJACKLLZ}
\alias{plotJACKLLZ}
\title{BoxPlot Jackknife of station locations
}
\description{BoxPlot Jackknife of station locations
}
\usage{
plotJACKLLZ(hjack, sta, proj = NULL,  PLOT=1)
}
\arguments{
  \item{hjack}{Output of hijack
}
  \item{sta}{station location list
}
  \item{proj}{projection list
}
 \item{PLOT}{plotting flag, 1,2. 
if plot =1 plot only boxplot, if plot=2 plot only map. Default=0
}
}
\details{
  takes the output of the HiJack function and extracts the pseudovalues
  and influence information for boxplots.
}
\value{
  Graphical side effects and
    \item{X}{influence of lon
}
  \item{Y}{influence of lat
}
  \item{Z}{influence of depth
  }
 
  
}
\references{
  Iversen, E. S., and J. M. Lees (1996), A statistical technique for
  validating velocity models,
  Bull. Seismol. Soc. Am. 86(6), 1853-1862.

}
\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}


\seealso{HiJACK, BLACKJACK,imageINFLUENCE, Vlocate
}
\examples{

data(cosopix)
data(wu_coso.vel)
data(coso_sta_LLZ)

COSOjack = HiJACK(cosopix, coso_sta_LLZ, wu_coso.vel)

proj = GEOmap::setPROJ(2, mean(coso_sta_LLZ$lat),
mean(coso_sta_LLZ$lon))

####  show stats
plotJACKLLZ(COSOjack, coso_sta_LLZ, proj, PLOT=1 )


####  show maps
plotJACKLLZ(COSOjack, coso_sta_LLZ, proj, PLOT=2 )



}
\keyword{misc}
