% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPC.R
\name{EvaluateRules}
\alias{EvaluateRules}
\title{EvaluateRules}
\usage{
EvaluateRules(x, type = "i", whichRules = 1:8, lcl = NA, cl = NA,
  ucl = NA, controlLimitDistance = 3, returnAllSelectedRules = F,
  parRules = NULL)
}
\arguments{
\item{x}{Series to be evaluated, numerical vector}

\item{type}{Type of control chart, either "i" for i-chart (default) or "c" for c-chart}

\item{whichRules}{Selection of Nelson rules beeing evaluated, vector with numbers from 1 to 8}

\item{lcl}{Lower control limit, single numeric value (expected as mean - controlLimitDistance * sigma), if missing the function calculates it from data}

\item{cl}{Central line, single numeric value (expected as mean), if missing the function calculates it from data}

\item{ucl}{Upper control limit, single numeric value (expected as mean + controlLimitDistance * sigma), if missing the function calculates it from data}

\item{controlLimitDistance}{Multiple of st.dev to be used to calculate limits, possible values: 1, 2, 3 (default); this parameter affect the interpretation of lcl and ucl parameters}

\item{returnAllSelectedRules}{Resulting dataframe will contain all selected rules, either True or False, if missing only valid rules returned}

\item{parRules}{Optional parameters for specific rules, for details see \code{\link{SetParameters}}}
}
\value{
Dataframe containing original vector and rules evaluation
}
\description{
Evaluates the selected Nelson rules for a given numerical vector.
}
\details{
# Only Rules 1-4 relevant for c-chart.\cr
# Check for non negative data for c-chart.\cr
# For controlLimitDistance less than or equal to 2 disable rule 5.\cr
# For controlLimitDistance less than or equal to 1 disable rule 5,6,8.\cr
# For returnAllSelectedRules=TRUE columns of invalid rules for given evaluation are filled with NAs.\cr
}
\examples{
# Evaluate data, use all 8 Nelson rules, limits are specified by user
EvaluateRules(x = rnorm(10), whichRules = 1:8, lcl = 0, cl = 50, ucl = 100)
#Evaluate only rule 1, 3, 5, calculate limits from data using c-chart formula,
#use 2 sigma instead of 3, modify default behaviour of rule by pars variable
#created by function SetParameters()
pars = SetParameters()
EvaluateRules(x = rpois(10, lambda = 15), type = 'c', whichRules = c(1,3,5), lcl = NA, cl = NA,
ucl = NA, controlLimitDistance = 2, parRules = pars)
# pars is object of optional parameters created by SetParameters() function
}
