% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend_functions.R
\name{tsEstimateAverageSeasonality}
\alias{tsEstimateAverageSeasonality}
\title{Estimate Average Seasonality}
\usage{
tsEstimateAverageSeasonality(timeStamps, seasonalitySeries, timeWindow)
}
\arguments{
\item{timeStamps}{The time stamps of the time series.}

\item{seasonalitySeries}{The series representing the seasonality.}

\item{timeWindow}{The time window used for averaging the seasonality.}
}
\value{
A list containing the estimated regime and the seasonality series:
\describe{
\item{\code{regime}}{The estimated regime of the time series.}
\item{\code{Seasonality}}{A data frame containing the average and varying seasonality series.}
\item{\code{averageSeasonalitySeries}}{The average seasonality series.}
\item{\code{varyingSeasonalitySeries}}{The varying seasonality series.}
}
}
\description{
This function estimates the average seasonality of a time series based on the given parameters.
}
\examples{
timeAndSeries <- ArdecheStMartin
timeStamps <- ArdecheStMartin[,1]
series  <- ArdecheStMartin[,2]
timeWindow <- 30*365  # 30 years
rs <- tsEvaDetrendTimeSeries(timeStamps, series, timeWindow)
nRunMn <- rs@nRunMn
cat("computing trend seasonality ...\n")
seasonalitySeries <- rs@detrendSeries
result <- tsEstimateAverageSeasonality(timeStamps, seasonalitySeries, timeWindow=rs@nRunMn)
#plot(result$regime, type = "l", xlab = "Day", ylab = "Regime", main = "Estimated Regime")
#plot(result$Seasonality$averageSeasonalitySeries, type = "l", xlab = "Day",
#ylab = "Seasonality", main = "Average Seasonality")
#plot(result$Seasonality$varyingSeasonalitySeries, type = "l", xlab = "Day",
#ylab = "Seasonality", main = "Varying Seasonality")
}
