% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnp_lobagoc.R
\name{pnp_lobagoc}
\alias{pnp_lobagoc}
\title{Internal function for fitting lobagoc distributions in plug-and-play SDMs.}
\usage{
pnp_lobagoc(data, method, object = NULL, v = 100, nu = 0.01, sigma = NULL)
}
\arguments{
\item{data}{dataframe of covariates}

\item{method}{one of either "fit" or "predict"}

\item{object}{fitted object returned by a pnp_... function. Only needed when method = "predict"}

\item{v}{Positive integer. The Number of votes to use (default is 100)}

\item{nu}{Numeric. Tuning parameter for nu-svm}

\item{sigma}{NULL or Numeric.  Tuning parameter of rbf kernel, will estimate if left NULL (default).}
}
\description{
This function both fits lobagoc distributions \insertCite{Drake2014-qz}{S4DM} and projects those distributions to new covariates.
}
\details{
For fitting, an object is not required (and will be ignored). For prediction, parameters v,nu,and sigma are not needed and will be ignored.
}
\references{
\insertAllCited{}
}
\keyword{internal}
