#include <R_ext/Rdynload.h>
#include <R.h>
#include <Rinternals.h>
#include <stdlib.h> // for NULL
#include <Rmath.h>
#include <R_ext/Rdynload.h>
#include <R_ext/RS.h>

/* FIXME:
   Check these declarations against the C/Fortran source code.
*/
#define FDEF(name){#name, (DL_FUNC) &F77_SUB(name), sizeof(name ## _t)/sizeof(name ## _t[0]), name ##_t}

/* .Fortran calls */
void F77_NAME(safe_fista)(double *x, double *y, int *k, int *nobs, int *nvars,
     int *nlam, double *ulam, double *eps, double *eps2, double *gamma, 
     double *beta, double *alpha, int *maxit, int *npass_beta, int *npass_gamma,
     double *int_b, double *int_g, int *int_p, int *jerr);

static R_NativePrimitiveArgType safe_fista_t[] = {REALSXP, REALSXP, INTSXP, INTSXP, INTSXP,
  INTSXP, REALSXP, REALSXP, REALSXP, REALSXP, 
  REALSXP, REALSXP, INTSXP, INTSXP, INTSXP,
  REALSXP, REALSXP, INTSXP, INTSXP};

static R_FortranMethodDef FortranEntries[] = {
    FDEF(safe_fista) ,
    {NULL, NULL, 0}
};


void R_init_SAFEPG(DllInfo *dll)
{
    R_registerRoutines(dll, NULL, NULL, FortranEntries, NULL);
    R_useDynamicSymbols(dll, FALSE);
}
