% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parammod.R
\name{param_norm}
\alias{param_norm}
\title{Parameter model for Normal Model}
\usage{
param_norm(a0, a1, b0, b1, c0, c1, d0, d1)
}
\arguments{
\item{a0, a1}{\code{mu0 ~ Normal(a0,a1)}}

\item{b0, b1}{\code{sig_0 ~ Gamma(b0,b1)}}

\item{c0, c1}{\code{muk ~ Normal(c0, c1)}}

\item{d0, d1}{\code{sig_k ~ Gamma(d0,d1)}}
}
\value{
\code{parammod} representing Normal distributed parameters
}
\description{
Normal parameter model:
\code{theta_0 = (mu0, sigma0)}
\code{theta_k = (muk, sigmak)}
}
\examples{
## theta0 = (mu0, sigma0); mu0~Normal(0,5); sigma0 ~ Gamma(1,1);
## thetak = (muk, sigmak); muk~Normal(0,3); sigmak ~ Gamma(5,2);
pn <- param_norm(0,5,1,1,0,3,5,2)
pn$r(5) ## a draw with 5 within-block parameters
}
