% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{get_static}
\alias{get_static}
\title{Static Profile Data}
\usage{
get_static(region_id, host_region = "us")
}
\arguments{
\item{region_id}{A numeric argument indicating the region of the profile.
    \itemize{
        \item 1 = US Region
        \item 2 = EU Region
        \item 3 = KR/TW Region
        \item 5 = CN Region
}}

\item{host_region}{The host region that the API call will be sent to. For most API calls, the same data will be
returned regardless of which region the request is sent to. Must be one of "us", "eu", "kr", "tw", "cn". For more
information on regionality, refer to
\href{https://develop.battle.net/documentation/guides/regionality-and-apis}{Regionality and APIs}.}
}
\description{
Provides static information (achievements, categories, criteria, and rewards)
 about SC2 profiles
in a given region.
}
\examples{
\donttest{
# Request static data of profiles in the EU region. Request is sent through
# the U.S. host region.
try(get_static(region_id = 2, host_region = "us"))

# Request static data of profiles in the China region. The request must be
# sent to the China gateway.
try(get_static(region_id = 5, host_region = "cn"))
}

}
\references{
\itemize{
   \item \href{https://develop.battle.net/documentation/starcraft-2/community-apis}{Blizzard Community API Documentation}
   \item \href{https://develop.battle.net/documentation/guides/regionality-and-apis}{Regionality and APIs}
   }
}
\seealso{
Other profile API calls: 
\code{\link{get_ladder_summary}()},
\code{\link{get_ladder}()},
\code{\link{get_metadata}()},
\code{\link{get_profile}()}
}
\concept{profile API calls}
