% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cs.R
\name{plot_cs}
\alias{plot_cs}
\title{Plot Inversion of Simultaneous Confidence Bands (SCBs) into Inner and Outer Simultaneous Confidence Regions (SCRs)}
\usage{
plot_cs(
  SCB,
  levels,
  type = "upper",
  x,
  y = NULL,
  mu_hat = NULL,
  mu_true = NULL,
  together = TRUE,
  xlab = "X1",
  ylab = "X2",
  level_label = TRUE,
  min.size = 5,
  palette = "gray",
  color_level_label = "black"
)
}
\arguments{
\item{SCB}{A numeric list returned by \code{regression_outcome_scb()},
\code{functional_outcome_scb()} or a custom list with two arrays of the same dimension:
\code{scb_up} and \code{scb_low}, representing the upper and lower confidence bounds
respectively. \verb{SCB$scb_up} and \verb{SCB$scb_low} should be numeric vectors (1D)
or matrices (2D) containing the upper simultaneous confidence interval.
Dimensions of \code{SCB$scb_up} and \code{SCB$scb_low} must match.}

\item{levels}{A numeric vector or list of scalers for different levels or matrix
containing interval sets to construct the confidence regions.
If \code{type} = "upper" or "lower", \code{levels} should be a vector.
"upper" represents upper excursion sets, and "lower" represents lower excursion sets.}

\item{type}{A character specifying the type of inverse sets to fit.
Choices are \code{"upper"} and \code{"lower"}. Default is \code{"upper"}.}

\item{x}{A numerical vector of x-axis coordinates for 1D and 2D cases.
For discrete coordinates, use a character vector.
The order of x should correspond to the order of \code{scb_up} and \code{scb_low} in \code{SCB}.}

\item{y}{Optional vector of y-axis coordinates for 2D data.}

\item{mu_hat}{A numeric array (1D) or matrix (2D) of estimated means.
If \code{mu_true} is provided, this will be overwritten by the true mean. Default is NULL.
An input must be provided for either \code{mu_hat} or \code{mu_true}.}

\item{mu_true}{Optional numeric array (1D) or matrix (2D) of true means,
which overrides \code{mu_hat} if provided. Default is NULL.}

\item{together}{Optional logical value for plotting option.
If \code{TRUE}, plots all confidence levels on the same figure;
otherwise, generates one plot per level. Default is \code{TRUE}.}

\item{xlab}{Optional character for the label of the x-axis. Default is \code{"x1"}.}

\item{ylab}{Optional character for the label of the y-axis. Default is \code{"x2"}.}

\item{level_label}{Optional logical input for level displaying option.
If \code{TRUE}, displays numeric level labels on contour lines for 2D confidence sets.
Default is \code{TRUE}.}

\item{min.size}{Optional logical input for minimum number of points
required for a contour to be labeled. Default is \code{5}.}

\item{palette}{Optional character value for the name of the HCL color palette
to use when plotting multiple levels together. Default is \code{"gray"}.}

\item{color_level_label}{Optional character value for the color used
for contour level labels. Default is \code{"black"}.}
}
\value{
A \code{ggplot2} object that includes both simultaneous confidence intervals
and simultaneous confidence region of excursion sets corresponding to levels assigned.
}
\description{
Visualizes simultaneous confidence regions of upper and lower excursion sets for
discrete, 1D or 2D data, using contour or band plots.
Supports plotting confidence regions at multiple levels and labeling contours.
}
\examples{

\donttest{
if (requireNamespace("mgcv", quietly = TRUE)) {
# example using pupil data
data(pupil)
pupil_fpca <- prepare_pupil_fpca(pupil)

fosr_mod <- mgcv::bam(percent_change ~ s(seconds, k=30, bs="cr") +
  s(seconds, by = use, k=30, bs = "cr") +
  s(id, by = Phi1, bs="re") +
  s(id, by = Phi2, bs="re") +
  s(id, by = Phi3, bs="re") +
  s(id, by = Phi4, bs="re"),
  method = "fREML", data = pupil_fpca, discrete = TRUE)

pupil_multiplier <- SCB_functional_outcome(data = pupil_fpca, object = fosr_mod,
                                   method = "multiplier",
                                   outcome = "percent_change",
                                   domain = "seconds", subset= c("use = 1"),
                                   id = "id")

pupil_multiplier <- tibble::as_tibble(pupil_multiplier)

plot_cs(pupil_multiplier,levels = c(-18), x = pupil_multiplier$domain,
        mu_hat = pupil_multiplier$mu_hat, xlab = "", ylab = "",
        level_label = T, min.size = 40, palette = "Spectral",
        color_level_label = "black")
}
}

x <- rnorm(50)
epsilon <- rnorm(50,0,sqrt(2))
y <- -1 + x + epsilon
df <- data.frame(x = x, y = y)
grid <- data.frame(x = seq(-1, 1, length.out = 50))
model <- "y ~ x"
results <- SCB_linear_outcome(df_fit = df, model = model, grid_df = grid)

results <- tibble::as_tibble(results)
plot_cs(results, levels = c(0), x = seq(-1, 1, length.out = 50), mu_hat = results$Mean,
       xlab = "x1", ylab = "y", level_label = T, min.size = 40, palette = "Spectral",
       color_level_label = "black")

}
\references{
Ren, J., Telschow, F. J. E., & Schwartzman, A. (2024).
Inverse set estimation and inversion of simultaneous confidence intervals.
\emph{Journal of the Royal Statistical Society: Series C (Applied Statistics)}, 73(4), 1082–1109.
\doi{10.1093/jrsssc/qlae027}
}
