% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliers.hdts.R
\name{outliers.hdts}
\alias{outliers.hdts}
\title{Multivariate Outlier Detection}
\usage{
outliers.hdts(x, r.max, type)
}
\arguments{
\item{x}{T by k data matrix: T data points in rows with each row being data at a given time point,
and k time series in columns.}

\item{r.max}{The maximum number of factors including stationary and non-stationary.}

\item{type}{The type of series, i.e., 1 if stationary or 2 if nonstationary.}
}
\value{
A list containing:
\itemize{
  \item x.clean -  The time series cleaned at the end of the procedure (n x m).
  \item P.clean - The estimate of the loading matrix if the number of factors is positive.
  \item Ft.clean - The estimated dynamic factors if the number of factors is positive.
  \item Nt.clean - The idiosyncratic residuals if the number of factors is positive.
  \item times.idi.out - The times of the idiosyncratic outliers.
  \item comps.idi.out - The components of the noise affected by the idiosyncratic outliers.
  \item sizes.idi.out - The sizes of the idiosyncratic outliers.
  \item stats.idi.out - The statistics of the idiosyncratic outliers.
  \item times.fac.out - The times of the factor outliers.
  \item comps.fac.out - The dynamic factors affected by the factor outliers.
  \item sizes.fac.out - The sizes of the factor outliers.
  \item stats.fac.out - The statistics of the factor outliers.
  \item x.kurt - The time series cleaned in the kurtosis sub-step (n x m).
  \item times.kurt - The outliers detected in the kurtosis sub-step.
  \item pro.kurt - The projection number of the detected outliers in the kurtosis sub-step.
  \item n.pro.kurt - The number of projections leading to outliers in the kurtosis sub-step.
  \item x.rand - The time series cleaned in the random projections sub-step (n x m).
  \item times.rand - The outliers detected in the random projections sub-step.
  \item x.uni - The time series cleaned after the univariate substep (n x m).
  \item times.uni - The vector of outliers detected with the univariate substep.
  \item comps.uni - The components affected by the outliers detected with the univariate substep.
  \item r.rob - The number of factors estimated (1 x 1).
  \item P.rob - The estimate of the loading matrix (m x r.rob).
  \item V.rob - The estimate of the orthonormal complement to P (m x (m - r.rob)).
  \item I.cov.rob - The matrix (V'GnV)^{-1} used to compute the statistics to detect the idiosyncratic outliers.
  \item IC.1 - The values of the information criterion of Bai and Ng.
}
}
\description{
Outlier detection in high dimensional time series by using projections as in Galeano, Peña and Tsay (2006).
}
\examples{
data(TaiwanAirBox032017)
output <- outliers.hdts(as.matrix(TaiwanAirBox032017[1:100,1:3]), r.max = 1, type =2)
}
\references{
Galeano, P., Peña, D., and Tsay, R. S. (2006). Outlier detection in
multivariate time series by projection pursuit. \emph{Journal of the American Statistical Association}, 101(474), 654-669.
}
