% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_sampling_functions.R
\name{sampling_bootstrap}
\alias{sampling_bootstrap}
\alias{sampling_shuffle}
\alias{sampling_partition}
\title{Sampling procedures used for testing capacity algorithm}
\usage{
sampling_bootstrap(data, prob = 1, dataDiv)

sampling_shuffle(data, side_variables)

sampling_partition(data, dataDiv, partition_trainfrac)
}
\arguments{
\item{data}{is a data.frame to be resampled}

\item{prob}{is numeric for the portion of data that should be sampled from the whole dataset (only in sampling_bootstrap)}

\item{dataDiv}{a character indicating column of data, with respect to which, data should be split before bootstrap}

\item{side_variables}{is a vector of characters indicating columns of data the will be reshuffled (only in sampling_shuffle)}

\item{partition_trainfrac}{is a numeric for the portion of data that will be used as a training and testing datasets}
}
\value{
Function sampling_bootstrap returns a data.frame with the same structure as initial data object, but with prob proportion
of observations for each dataDiv level. Function sampling_shuffle returns a data.frame with the same structure as initial data object with 
shuffled values of columns given in side_variables argument. Function sampling_partition returns a list of two data.frame objects - 
train and test that has the same structure as initial data argument with partition_trainfrac and 1-partition_trainfrac observations, respectively.
}
\description{
Internal, auxiliary functions
}
\details{
These function allow to re-sample, bootstrap and divide initial dataset
}
\examples{
data=data_example1
dataBootstrap = SLEMI:::sampling_bootstrap(data=data,prob=0.8,data$signal)
dataShuffle = SLEMI:::sampling_shuffle(data=data,"sideVar")
dataTrainTest = SLEMI:::sampling_partition(data=data,dataDiv=data$signal,partition_trainfrac=0.6)
}
\keyword{internal}
