% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_coef.R
\name{get_coef}
\alias{get_coef}
\title{A function that extracts coefficients.}
\usage{
get_coef(res_SMAHP)
}
\arguments{
\item{res_SMAHP}{Outputs from SMAHP}
}
\value{
A data frame which includes the name of exposure and mediator with coefficients from mediation and outcome model.
\item{beta1}{The coefficient estimate of exposure in mediation model}
\item{beta2}{The coefficient estimate of mediator in outcome model}
\item{beta3}{The coefficient estimate of exposure in outcome model}
}
\description{
A function that extracts coefficients from mediation and outcome model.
}
\examples{
\donttest{
data(example_dat)
surv_dat <- example_dat$surv_dat
res_SMAHP <- SMAHP(example_dat$X, example_dat$M, example_dat$C, time = surv_dat$time,
status = surv_dat$status)
get_coef(res_SMAHP)
}
}
