% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stderrs_specific_var.R
\name{stderrs_specific_var}
\alias{stderrs_specific_var}
\title{stderrs_specific_var}
\usage{
stderrs_specific_var(stderrstab, varname)
}
\arguments{
\item{stderrstab}{A table that includes standard error of betahat for a specific variable.}

\item{varname}{Specify the name of the variable of interest.}
}
\value{
A vector of standard error of betahats for a single variable from the model.
}
\description{
A function to retrieve a vector of standard error of coefficient estimates (betahats)
 of each taxa for one specific variable.
}
\examples{
\donttest{
data(combinedamgut) # A complete data containing columns with taxa and clinical covariates.

# Note: The line below will use a toy example with the first 30 out of 138 taxa.
OTUtab = combinedamgut[ , 8:37]
# Clinical/demographic covariates (phenotypic data):
# Note: All of these covariates will be included in the regression, so
# please make sure that phenodat includes the variables that will be analyzed only.
phenodat = combinedamgut[, 1:7] # first column is ID, so not using it.
# Obtain indices of each grouping factor
# In this example, a variable indicating the status of living with a dog was chosen (i.e. bin_dog).
# Accordingly, Groups A and B imply living without and with a dog, respectively.
 newindex_grpA = which(combinedamgut$bin_dog == 0)
 newindex_grpB = which(combinedamgut$bin_dog == 1)

SOHPIEres <- SOHPIE_DNA(OTUdat = OTUtab, clindat = phenodat,
groupA = newindex_grpA, groupB = newindex_grpB, c = 0.5)

# stderrs() function will return standard error of betahats only.
stderrstab <- stderrs(SOHPIEres)

# stderrs_specific_var() will return standard error of coefficient estimates of
# a single variable of interest.
stderrs_specific_var(stderrstab = stderrstab, varname = "bin_dog")
}
}
