% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.distances.R
\name{calc.distances}
\alias{calc.distances}
\title{calc.distances}
\usage{
calc.distances(trj, mol.2 = FALSE, sele = FALSE, atoms = NULL, cap = NULL)
}
\arguments{
\item{trj}{contains the trajectory coordinates (array with three dimensions obtained by rioxdr)}

\item{mol.2}{contains the atom indexes of the second molecule in case only intermolecular distances should be computed}

\item{sele}{contains the selection of distances coming from the native_contacts function}

\item{atoms}{contains a list of atoms indexes on which the distances will be computed}

\item{cap}{If a number is given, distances greater than this value are set at the cap value}
}
\value{
A matrix containing the set of distances computed for all the frames.
}
\description{
Function to compute distances to be used to train the SOM
}
\examples{
# Read reference structure file with native conformation
struct <- read.struct(system.file("extdata", "HIF2a.gro", package = "SOMMD"))
# Read the trajectory
trj <- read.trj(trjfile = system.file("extdata", "HIF2a-MD.xtc", package = "SOMMD"),
  topfile = system.file("extdata", "HIF2a.gro", package = "SOMMD"))
# Select only Cbeta atoms to perform the analysis
sele_atoms <- which(trj$top$elety=="CB")
# Choose only native contacts
sele_dists <- native.cont(struct=struct, distance=1.0, atoms=sele_atoms)
# Compute distances for SOM training.
DIST <- calc.distances(trj, mol.2=FALSE, sele=sele_dists, atoms=sele_atoms)

}
\author{
Stefano Motta \email{stefano.motta@unimib.it}
}
