% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remap.data.R
\name{remap.data}
\alias{remap.data}
\title{map data to existing SOM}
\usage{
remap.data(SOM, X, add = FALSE)
}
\arguments{
\item{SOM}{a trained SOM}

\item{X}{a data set with the same number of features of the dataset used to train the SOM}

\item{add}{whether to append the new data to the ones used to train the SOM}
}
\value{
An object of class "kohonen" with the new data mapped
}
\description{
Assign new data to a pre-trained SOM
}
\examples{
#Read example SOM data
som_model <- readRDS(system.file("extdata", "SOM_HIFa.rds", package = "SOMMD"))
#Read a trajectory that was not used to train the som
trj_2 <- read.trj(trjfile = system.file("extdata", "HIF2a-MD-2.xtc", package = "SOMMD"),
  topfile = system.file("extdata", "HIF2a.gro", package = "SOMMD"))
#Read reference structure file
gro <- read.struct(system.file("extdata", "HIF2a.gro", package = "SOMMD"))
#Selection of the same intermolecular distances used to train the SOM
protein.sele <- which(gro$atom$resid!="020")
ligand.sele <- which(gro$atom$resid=="020")
heavy.atoms <- which(startsWith(gro$atom$elety, "H")==FALSE)
sele.dists <- native.cont(struct=gro, distance=0.6, mol.2=ligand.sele, atoms=heavy.atoms)
# Compute distances on new simulations (the same used for SOM training)
dist_2 <- calc.distances(trj_2, mol.2=ligand.sele, sele=sele.dists, atoms=heavy.atoms)
# Map new data on the existing SOM
som_model_2 <- remap.data(SOM=som_model, X=dist_2)
}
\author{
Stefano Motta \email{stefano.motta@unimib.it}
}
