# Funzione di test per matrix2graph
test_that("matrix2graph works correctly", {
  # Load SOM
  som_file <- system.file("extdata", "som_model.rds", package = "SOMMD")
  som_model <- readRDS(som_file)
  tr_mat <- comp.trans.mat(som_model, start = 1)
  
  # Execute Function
  SOM.hc <- c(1,2,2,3,3,3,3,1,3,4,1,1,2,3,3,3,3,3,1,4,1,5,5,3,3,
              3,3,4,4,6,1,1,5,5,5,5,4,4,4,6,7,5,5,5,5,5,4,6,6,6,
              7,7,5,5,5,5,3,6,6,6,2,7,8,8,5,3,3,6,6,6,9,10,8,8,8,
              8,3,6,6,6,10,8,8,8,8,8,8,6,6,6,10,10,8,8,8,8,8,6,6,6)
  colorset <- c("#1f78b4", "#33a02c", "#e31a1c", "#ffff88", "#6a3d9a", 
                "#a0451f", "#96c3dc", "#fbb25c", "#ff7f00", "#bea0cc", 
                "#747474", "#f88587", "#a4db77")
  net <- matrix2graph(tr_mat, som_model, SOM.hc, colorset, diag=FALSE)  
  
  #Verify the network edge width
  expected_values <- c(0.0000000, 2.2284935, 1.2883582, 2.4526184, 0.0000000, 1.0209997, 1.8084393,
                       0.0000000, 0.0000000, 0.0000000, 1.4957375, 2.0419994, 0.0000000, 1.8084393,
                       1.2883582, 0.0000000, 1.0209997, 1.6651788, 0.6441791, 1.0209997, 1.9325373,
                       2.9914750, 0.0000000, 1.2883582, 1.0209997, 0.0000000, 0.0000000, 2.0419994,
                       2.3837459, 0.6441791, 0.6441791, 0.0000000, 0.0000000, 0.0000000, 0.0000000,
                       1.0209997, 0.0000000, 0.6441791, 0.0000000, 0.0000000, 0.0000000, 0.0000000,
                       0.0000000, 0.0000000, 2.2284935, 0.0000000, 2.2284935, 0.0000000, 0.0000000,
                       0.0000000)
  expect_equal(igraph::E(net)$width[1:50], expected_values, tolerance = 1e-6)

})

