# Funzione di test per remap.data
test_that("remap.data works correctly with add=FALSE", {
  # Load SOM
  som_file <- system.file("extdata", "SOM.rds", package = "SOMMD")
  som_model <- readRDS(som_file)

  # Define new features
  features <- matrix(c(-1.1392005,  0.40379356, -1.35463418, -1.31105215,
                       -1.0184372,  1.09207804, -1.26022143, -1.22359036,
                       -1.4209815,  0.40379356, -1.31686908, -1.26732126,
                       -0.9781827,  0.78617383, -1.26022143, -1.35478304,
                       -1.0586916,  0.63322172, -1.43016439, -1.39851393,
                       -0.5353840,  2.00979069, -1.33575163, -1.09239769,
                       -0.5353840,  1.39798226, -1.20357378, -1.22359036,
                       -1.0989460,  1.09207804, -1.33575163, -1.09239769,
                       -1.0989460,  0.48026962, -1.16580868, -1.22359036,
                       -0.9781827,  0.70969778, -1.27910398, -1.31105215,
                       -0.8574194,  1.09207804, -1.26022143, -1.26732126,
                       -0.8574194,  1.01560199, -1.35463418, -1.31105215,
                       -1.0989460,  0.70969778, -1.37351674, -1.35478304,
                       -1.1794549,  0.02141329, -1.35463418, -1.22359036,
                       -1.2197094,  1.01560199, -1.22245633, -1.04866679,
                       -1.2197094,  0.63322172, -1.29798653, -1.26732126,
                       -0.0925852,  0.78617383, -0.69374491, -0.78628144,
                        0.5112313, -0.43744303,  0.40144303,  0.30699086,
                        0.3904680, -0.20801487,  0.47697323,  0.35072176,
                       -0.3341118, -0.89629935,  0.09932222,  0.04460551), ncol=4)  
  
  # Execute Function
  som_new <- remap.data(SOM=som_model, X=features, add=FALSE)
  
  #Verify the obtained classification
  expected_classif <- c(4, 16, 4, 4, 4, 16, 4, 4, 4, 19, 4, 4, 3, 19, 4, 4, 4, 19, 4, 4)
  expect_equal(som_new$unit.classif, expected_classif, tolerance = 1e-6)

  #Verify the size of the data in the som object
  expected_size <- c(20, 4)
  expect_equal(dim(som_new$data[[1]]), expected_size, tolerance = 1e-6)

})

test_that("remap.data works correctly with add=TRUE", {
  # Load SOM
  som_file <- system.file("extdata", "SOM.rds", package = "SOMMD")
  som_model <- readRDS(som_file)

  # Define new features
  features <- matrix(c(-1.1392005,  0.40379356, -1.35463418, -1.31105215,
                       -1.0184372,  1.09207804, -1.26022143, -1.22359036,
                       -1.4209815,  0.40379356, -1.31686908, -1.26732126,
                       -0.9781827,  0.78617383, -1.26022143, -1.35478304,
                       -1.0586916,  0.63322172, -1.43016439, -1.39851393,
                       -0.5353840,  2.00979069, -1.33575163, -1.09239769,
                       -0.5353840,  1.39798226, -1.20357378, -1.22359036,
                       -1.0989460,  1.09207804, -1.33575163, -1.09239769,
                       -1.0989460,  0.48026962, -1.16580868, -1.22359036,
                       -0.9781827,  0.70969778, -1.27910398, -1.31105215,
                       -0.8574194,  1.09207804, -1.26022143, -1.26732126,
                       -0.8574194,  1.01560199, -1.35463418, -1.31105215,
                       -1.0989460,  0.70969778, -1.37351674, -1.35478304,
                       -1.1794549,  0.02141329, -1.35463418, -1.22359036,
                       -1.2197094,  1.01560199, -1.22245633, -1.04866679,
                       -1.2197094,  0.63322172, -1.29798653, -1.26732126,
                       -0.0925852,  0.78617383, -0.69374491, -0.78628144,
                        0.5112313, -0.43744303,  0.40144303,  0.30699086,
                        0.3904680, -0.20801487,  0.47697323,  0.35072176,
                       -0.3341118, -0.89629935,  0.09932222,  0.04460551), ncol=4)  
  
  # Execute Function
  som_new <- remap.data(SOM=som_model, X=features, add=TRUE)
  
  #Verify the obtained classification
  expected_classif <- c(15,  5,  5,  5, 15, 20, 10, 10,  5,  5, 20, 10,  5,  5, 25, 25, 20, 15, 20, 20, 15, 20, 15, 10, 10,
                         5, 10, 15, 15,  5,  5, 15, 25, 25,  5, 10, 15, 15,  5, 15, 15,  4,  5, 15, 20,  5, 20,  5, 20, 10,
                        23, 18, 23,  3, 23,  8, 18,  3, 23,  9,  3, 13,  2, 13,  9, 23, 13,  8,  2,  8, 12, 13,  1, 13, 23,
                        23, 23, 23, 13,  9,  3,  3,  8,  7, 13, 19, 23,  2, 13,  8,  8, 18,  8,  3,  8, 13, 13, 13,  3,  8,
                        16,  7, 17, 11, 11, 22,  3, 22,  1, 21, 11,  6, 17,  7,  6, 16, 11, 21, 22,  2, 17,  7, 22,  7, 16,
                        22,  7, 12,  6, 22, 22, 21,  6,  7,  1, 22, 16, 11, 12, 17, 17, 17,  7, 17, 16, 17,  1, 11, 16, 12,
                         4, 16,  4,  4,  4, 16,  4,  4,  4, 19,  4,  4,  3, 19,  4,  4,  4, 19,  4,  4)
  expect_equal(som_new$unit.classif, expected_classif, tolerance = 1e-6)

  #Verify the size of the data in the som object
  expected_size <- c(170, 4)
  expect_equal(dim(som_new$data[[1]]), expected_size, tolerance = 1e-6)

})



