% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SQI.R
\name{ScoingIndex}
\alias{ScoingIndex}
\title{Soil Quality Index Based on Linear Scoring}
\usage{
ScoingIndex(DataFrame, OptimumValue)
}
\arguments{
\item{DataFrame}{Data set with first column as factors}

\item{OptimumValue}{Optimum value of each variable; Minimum and maximum coded as "1111" and "9999" respectively.}
}
\value{
\itemize{
  \item Raw_mean: Raw score
  \item Index: Final index
}
}
\description{
Soil Quality Index Based on Linear Scoring
}
\examples{
library("SQI")
OP<-c(7,1111,9999,9999,9999,9999,9999,9999,9999,9999,1111)
ScoreIndex<-ScoingIndex(DataFrame = Data,OptimumValue = OP)
}
\references{
\itemize{
\item Bastida, F., Zsolnay, A., Hernández, T., & García, C. (2008). Past, present and future of soil quality indices: a biological perspective. Geoderma, 147(3-4), 159-171.
\item Doran, J. W., & Parkin, T. B. (1994). Defining and assessing soil quality. Defining soil quality for a sustainable environment, 35, 1-21.
\item Mukherjee, A., & Lal, R. (2014). Comparison of soil quality index using three methods. PloS one, 9(8), e105981.
}
}
