% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verifyAlleleANHIG.R
\name{verifyAlleleANHIG}
\alias{verifyAlleleANHIG}
\title{Verifies the allele entered is present in the IMGT protein alignments}
\usage{
verifyAlleleANHIG(allele, filename, alignments)
}
\arguments{
\item{allele}{An allele name written in the IPD-IMGT/HLA Database format.}

\item{filename}{The full file path of the user specified dataset if the user wishes to use their own file, or the pre-bundled Solberg dataset. User provided datasets must be a .dat, .txt, or.csv file, and must conform to the structure and format of the Solberg dataset.}

\item{alignments}{A list object of sub-lists of data frames of protein alignments for the HLA and HLA-region genes supported in the ANHIG/IMGTHLA GitHub Repository. Alignments will always be the most recent version IPD-IMGT/HLA Database version.}
}
\value{
TRUE if allele is present in the IMGTprotalignment object. Otherwise, a vector containing FALSE and an error message is returned.
}
\description{
Verifies the allele entered is present in IMGT protein alignments
}
\note{
For internal SSHAARP use only.
}
