% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/browse.R
\name{sc_browse}
\alias{sc_browse}
\alias{sc_browse_preferences}
\alias{sc_browse_table}
\alias{sc_browse_database}
\alias{sc_browse_catalogue}
\alias{sc_browse_ogd}
\title{Links to important 'STATcube' and 'OGD' pages}
\usage{
sc_browse(server = "ext")

sc_browse_preferences(server = "ext")

sc_browse_table(table, server = "ext")

sc_browse_database(database, server = NULL, open = FALSE)

sc_browse_catalogue(server = "ext")

sc_browse_ogd()
}
\arguments{
\item{server}{A STATcube API server. Defaults to the external Server via
\code{"ext"}. Other options are \code{"red"} for the editing server and \code{"prod"} for
the production server. External users should always use the default option \code{"ext"}.}

\item{table}{a table id}

\item{database}{a database id}

\item{open}{If \code{FALSE} (the default), open the infopage for the database.
Otherwise, open the table view.}
}
\value{
the URL of a specific webpage which is opened by default
in a web browser.
}
\description{
A collection of links, to browse important 'STATcube' pages.
}
\section{Functions}{
\itemize{
\item \code{sc_browse()}: opens the home menu of 'STATcube'

\item \code{sc_browse_preferences()}: opens the preference menu with the API key

\item \code{sc_browse_table()}: shows the info page for a table

\item \code{sc_browse_database()}: shows the info page for a database

\item \code{sc_browse_catalogue()}: shows the data catalogue explorer

\item \code{sc_browse_ogd()}: shows the landing page for OGD datasets

}}
\examples{
sc_browse()
sc_browse_preferences()
sc_browse_table('defaulttable_deake005')
sc_browse_database('deake005')
sc_browse_catalogue()
sc_browse_ogd()
}
