% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SILO.R
\name{SILOReport}
\alias{SILOReport}
\title{Write SILO data report to word document. The report includes output from SILOSiteSummary(), SILOQualityCodes(),
SILOMortonQualityCodes(). SILOMap(), SILOMonthlyRainfall(), SILOCumulativeDeviation() and SILODoubleMass().}
\usage{
SILOReport(SILO, filename, path = getwd(), cols = pkg.env$cols)
}
\arguments{
\item{SILO}{a list of sites with SILO data, as created by SILOLoad()}

\item{filename}{filename to write the report to.}

\item{path}{Optional. Folder to save the report to, defaults to current working directory}

\item{cols}{Optional. vector of colours to use for the monthly rainfall and cumulative deviation plots. Must be at least as long as the number of sites in the SILO list.}
}
\value{
Nothing to the environment. A word document report is written to "filename".
}
\description{
Write SILO data report to word document. The report includes output from SILOSiteSummary(), SILOQualityCodes(),
SILOMortonQualityCodes(). SILOMap(), SILOMonthlyRainfall(), SILOCumulativeDeviation() and SILODoubleMass().
}
\examples{
\dontrun{
X<-SILOLoad(c("24001","24002","24003"),path="./SWTools/extdata")
SILOReport(X,"MyReport.docx") #requires pandoc installed
}

}
