% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/master_patient_index.R
\docType{data}
\name{master_patient_index}
\alias{master_patient_index}
\title{Master Patient Index}
\format{
A tibble with 10,000 rows and 11 variables:
\describe{
  \item{PseudoNHSNumber }{A Pseudonymised NHS Patient Identifier}
  \item{Sex}{The identifiable sex of the patient}
  \item{Smoker}{Health Condition Flag: 1 denotes if the patient is a smoker}
  \item{Diabetes}{Health Condition Flag: 1 denotes if the patient has diabetes}
  \item{Dementia}{Health Condition Flag: 1 denotes if the patient has dementia}
  \item{Obesity}{Health Condition Flag: 1 denotes if the patient is Obese}
  \item{Age}{Age of the patient}
  \item{IMD_Decile}{The decile of indices of multiple deprivation: \url{https://www.gov.uk/government/statistics/english-indices-of-deprivation-2019}}
  \item{Ethnicity}{The identifiable ethnicity of the patient}
  \item{Locality}{The region where the patient lives - sampled from Gloucestershire Clinical Commissioning Group}
  \item{PrimaryCareNetwork}{The network of General Practioners that the patient is registerd with - sampled from Gloucestershire Clinical Commissioning Group}
  }
}
\source{
Generated by Asif Laldin \email{a.laldin@nhs.net}, Feb-2022
}
\usage{
master_patient_index
}
\description{
A fabricated Master Patient Index (MPI) inspired by Gloucestershire's population
to be used with functions included in SangerTools
}
\examples{
library(dplyr)
data(master_patient_index)
# Convert diabetes data to factor'
master_patient_index \%>\%
 glimpse()
}
\keyword{datasets}
