% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_excel_reader.R
\name{multiple_excel_reader}
\alias{multiple_excel_reader}
\title{Read Multiple Excel files into R}
\usage{
multiple_excel_reader(
  file_path,
  pattern = "*.xlsx",
  sheet = 1,
  rows_to_skip = 0,
  col_names = TRUE
)
}
\arguments{
\item{file_path}{The Directory in which the files are located}

\item{pattern}{The file extension of the files of which you are going to read. Defaults to "*.xlsx"}

\item{sheet}{Sheet to read. Either a string (the name of a sheet), or an integer (the position of the sheet). Defaults to the first sheet}

\item{rows_to_skip}{The number of rows from the top to be excluded}

\item{col_names}{A boolean value to determine if column headers name are present in files. Currently only accepts TRUE}
}
\value{
a data frame object full of file paths
}
\description{
This function reads multiple excel files into R after which all files are aggregated into  a single data frame.


There are assumptions about they underlying files:
\itemize{
  \item All files must have column names for each column (The function will fail without this; later versions will amend this)
  \item All files have the same number of columns
  \item All files have the same column names
  \item All files should have data starting from the same row number
  \item All relevant data is stored in the same sheet in each of the files
}
To understand more about the underlying function that `multiple_excel_reader` wraps around \href{https://www.rdocumentation.org/packages/readxl/versions/0.1.1/topics/read_excel}{Click Here}
}
\examples{
\dontrun{
combined_excel_files <- multiple_excel_reader("Inputs/", 1, TRUE)
}
}
